/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.security.common;

import com.pushtechnology.diffusion.client.features.control.clients.SystemAuthenticationControl;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.Immutable;

@Immutable
public final class SystemAuthenticationConfigurationImpl
implements SystemAuthenticationControl.SystemAuthenticationConfiguration {
    private final Collection<SystemAuthenticationControl.SystemPrincipal> principals;
    private final SystemAuthenticationControl.AnonymousConnectionAction anonymousAction;
    private final Set<String> rolesForAnonymousSessions;
    private final Map<String, SystemAuthenticationControl.SessionPropertyValidation> trustedProperties;

    public SystemAuthenticationConfigurationImpl(Collection<SystemAuthenticationControl.SystemPrincipal> principals, SystemAuthenticationControl.AnonymousConnectionAction anonymousAction, Set<String> rolesForAnonymousSessions) {
        this(principals, anonymousAction, rolesForAnonymousSessions, Collections.emptyMap());
    }

    public SystemAuthenticationConfigurationImpl(Collection<SystemAuthenticationControl.SystemPrincipal> principals, SystemAuthenticationControl.AnonymousConnectionAction anonymousAction, Set<String> rolesForAnonymousSessions, Map<String, SystemAuthenticationControl.SessionPropertyValidation> trustedProperties) {
        this.principals = principals;
        this.anonymousAction = anonymousAction;
        this.rolesForAnonymousSessions = rolesForAnonymousSessions;
        this.trustedProperties = trustedProperties;
    }

    @Override
    public Collection<SystemAuthenticationControl.SystemPrincipal> getPrincipals() {
        return this.principals;
    }

    @Override
    public SystemAuthenticationControl.AnonymousConnectionAction getAnonymousAction() {
        return this.anonymousAction;
    }

    @Override
    public Set<String> getRolesForAnonymousSessions() {
        return this.rolesForAnonymousSessions;
    }

    @Override
    public Map<String, SystemAuthenticationControl.SessionPropertyValidation> getTrustedClientProposedProperties() {
        return this.trustedProperties;
    }

    public int hashCode() {
        int prime = 31;
        int result = this.principals.hashCode();
        result += 31 * result + this.anonymousAction.hashCode();
        result += 31 * result + this.rolesForAnonymousSessions.hashCode();
        result += 31 * result + this.trustedProperties.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SystemAuthenticationConfigurationImpl other = (SystemAuthenticationConfigurationImpl)o;
        return this.anonymousAction.equals((Object)other.anonymousAction) && this.principals.equals(other.principals) && this.rolesForAnonymousSessions.equals(other.rolesForAnonymousSessions) && this.trustedProperties.equals(other.trustedProperties);
    }

    public String toString() {
        return String.format("%s[%s, anonymous connection action=%s, %s, %s]", new Object[]{this.getClass().getSimpleName(), this.principals, this.anonymousAction, this.rolesForAnonymousSessions, this.trustedProperties});
    }
}

