/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.security.common;

import com.pushtechnology.diffusion.client.features.control.clients.SecurityControl;
import com.pushtechnology.diffusion.client.types.GlobalPermission;
import com.pushtechnology.diffusion.client.types.PathPermission;
import com.pushtechnology.diffusion.client.types.serialisation.EnumConverter;
import com.pushtechnology.diffusion.collections.ImmutableSet;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.io.serialisation.ReadSerialiser;
import com.pushtechnology.diffusion.io.serialisation.WriteSerialiser;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import com.pushtechnology.diffusion.security.common.RoleImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.jcip.annotations.Immutable;

@Immutable
public final class RoleSerialiser
extends AbstractSerialiser<SecurityControl.Role> {
    public static final EnumConverter<PathPermission> PROTOCOL_22_PATH_PERMISSION_CONVERTER = new EnumConverter.Builder<PathPermission>(PathPermission.class).bimap(0, PathPermission.READ_TOPIC).bimap(1, PathPermission.UPDATE_TOPIC).bimap(2, PathPermission.MODIFY_TOPIC).bimap(3, PathPermission.SEND_TO_MESSAGE_HANDLER).bimap(4, PathPermission.SEND_TO_SESSION).bimap(5, PathPermission.SELECT_TOPIC).bimap(6, PathPermission.QUERY_OBSOLETE_TIME_SERIES_EVENTS).bimap(7, PathPermission.EDIT_TIME_SERIES_EVENTS).bimap(8, PathPermission.EDIT_OWN_TIME_SERIES_EVENTS).bimap(9, PathPermission.ACQUIRE_LOCK).bimap(10, PathPermission.UNKNOWN_PATH_PERMISSION).bimap(11, PathPermission.EXPOSE_BRANCH).build();
    public static final EnumConverter<GlobalPermission> PROTOCOL_16_GLOBAL_PERMISSION_CONVERTER = new EnumConverter.Builder<GlobalPermission>(GlobalPermission.class).bimap(0, GlobalPermission.AUTHENTICATE).bimap(1, GlobalPermission.VIEW_SESSION).bimap(2, GlobalPermission.MODIFY_SESSION).bimap(3, GlobalPermission.REGISTER_HANDLER).bimap(4, GlobalPermission.VIEW_SERVER).bimap(5, GlobalPermission.CONTROL_SERVER).bimap(6, GlobalPermission.VIEW_SECURITY).bimap(7, GlobalPermission.MODIFY_SECURITY).bimap(8, GlobalPermission.UNKNOWN_GLOBAL_PERMISSION).bimap(9, GlobalPermission.READ_TOPIC_VIEWS).bimap(10, GlobalPermission.MODIFY_TOPIC_VIEWS).build();
    public static final EnumConverter<PathPermission> PROTOCOL_14_PATH_PERMISSION_CONVERTER = new EnumConverter.Builder<PathPermission>(PathPermission.class).bimap(0, PathPermission.READ_TOPIC).bimap(1, PathPermission.UPDATE_TOPIC).bimap(2, PathPermission.MODIFY_TOPIC).bimap(3, PathPermission.SEND_TO_MESSAGE_HANDLER).bimap(4, PathPermission.SEND_TO_SESSION).bimap(5, PathPermission.SELECT_TOPIC).bimap(6, PathPermission.QUERY_OBSOLETE_TIME_SERIES_EVENTS).bimap(7, PathPermission.EDIT_TIME_SERIES_EVENTS).bimap(8, PathPermission.EDIT_OWN_TIME_SERIES_EVENTS).bimap(9, PathPermission.ACQUIRE_LOCK).bimap(10, PathPermission.UNKNOWN_PATH_PERMISSION).map(PathPermission.EXPOSE_BRANCH, 10).build();
    private final EnumConverter<GlobalPermission> globalPermissionConverter;
    private final EnumConverter<PathPermission> topicPermissionConverter;
    private final LockedPrincipalWriter lockingPrincipalWriter;
    private final LockedPrincipalReader lockingPrincipalReader;

    static RoleSerialiser createProtocol14RoleSerialiser() {
        return new RoleSerialiser(new EnumConverter.Builder<GlobalPermission>(GlobalPermission.class).bimap(0, GlobalPermission.AUTHENTICATE).bimap(1, GlobalPermission.VIEW_SESSION).bimap(2, GlobalPermission.MODIFY_SESSION).bimap(3, GlobalPermission.REGISTER_HANDLER).bimap(4, GlobalPermission.VIEW_SERVER).bimap(5, GlobalPermission.CONTROL_SERVER).bimap(6, GlobalPermission.VIEW_SECURITY).bimap(7, GlobalPermission.MODIFY_SECURITY).bimap(8, GlobalPermission.UNKNOWN_GLOBAL_PERMISSION).map(GlobalPermission.READ_TOPIC_VIEWS, 8).map(GlobalPermission.MODIFY_TOPIC_VIEWS, 8).build(), PROTOCOL_14_PATH_PERMISSION_CONVERTER);
    }

    static RoleSerialiser createProtocol16RoleSerialiser() {
        return new RoleSerialiser(PROTOCOL_16_GLOBAL_PERMISSION_CONVERTER, PROTOCOL_14_PATH_PERMISSION_CONVERTER);
    }

    static RoleSerialiser createProtocol17RoleSerialiser() {
        return new RoleSerialiser(PROTOCOL_16_GLOBAL_PERMISSION_CONVERTER, PROTOCOL_14_PATH_PERMISSION_CONVERTER, RoleSerialiser::writeLockedPrincipal, RoleSerialiser::readLockedPrincipal);
    }

    static RoleSerialiser createProtocol22RoleSerialiser() {
        return new RoleSerialiser(PROTOCOL_16_GLOBAL_PERMISSION_CONVERTER, PROTOCOL_22_PATH_PERMISSION_CONVERTER, RoleSerialiser::writeLockedPrincipal, RoleSerialiser::readLockedPrincipal);
    }

    private RoleSerialiser(EnumConverter<GlobalPermission> globalPermissionConverter, EnumConverter<PathPermission> topicPermissionConverter) {
        this(globalPermissionConverter, topicPermissionConverter, (out, role) -> {}, in -> null);
    }

    private RoleSerialiser(EnumConverter<GlobalPermission> globalPermissionConverter, EnumConverter<PathPermission> topicPermissionConverter, LockedPrincipalWriter lockingPrincipalWriter, LockedPrincipalReader lockingPrincipalReader) {
        this.globalPermissionConverter = globalPermissionConverter;
        this.topicPermissionConverter = topicPermissionConverter;
        this.lockingPrincipalWriter = lockingPrincipalWriter;
        this.lockingPrincipalReader = lockingPrincipalReader;
    }

    @Override
    public void write(OutputStream out, SecurityControl.Role role) throws IOException {
        EncodedDataCodec.writeString(out, role.getName());
        RoleSerialiser.writeEnums(out, this.globalPermissionConverter, role.getGlobalPermissions());
        RoleSerialiser.writeEnums(out, this.topicPermissionConverter, role.getDefaultPathPermissions());
        this.writePathPermissionsMap(out, role.getPathPermissions());
        RoleSerialiser.writeStrings(out, role.getIncludedRoles());
        this.lockingPrincipalWriter.write(out, role);
    }

    @Override
    protected SecurityControl.Role readUnchecked(InputStream in) throws IOException {
        return new RoleImpl(EncodedDataCodec.readString(in), this.readGlobalPermissions(in), this.readPathPermissions(in), this.readPathPermissionsMap(in), ImmutableSet.from(RoleSerialiser.readStrings(in)), (String)this.lockingPrincipalReader.read(in));
    }

    void writePathPermissions(OutputStream out, Set<PathPermission> ps) throws IOException {
        RoleSerialiser.writeEnums(out, this.topicPermissionConverter, ps);
    }

    void writePathPermissionsMap(OutputStream out, Map<String, Set<PathPermission>> topicPermissions) throws IOException {
        RoleSerialiser.writeMap(out, EncodedDataCodec::writeString, this::writePathPermissions, topicPermissions);
    }

    private Set<GlobalPermission> readGlobalPermissions(InputStream in) throws IOException {
        return Collections.unmodifiableSet(RoleSerialiser.readEnumSet(GlobalPermission.class, in, this.globalPermissionConverter));
    }

    Set<PathPermission> readPathPermissions(InputStream in) throws IOException {
        return Collections.unmodifiableSet(RoleSerialiser.readEnumSet(PathPermission.class, in, this.topicPermissionConverter));
    }

    Map<String, Set<PathPermission>> readPathPermissionsMap(InputStream in) throws IOException {
        return RoleSerialiser.readMap(in, EncodedDataCodec::readString, this::readPathPermissions);
    }

    private static void writeLockedPrincipal(OutputStream out, SecurityControl.Role role) throws IOException {
        Optional<String> lockingPrincipal = role.getLockingPrincipal();
        if (lockingPrincipal.isPresent()) {
            EncodedDataCodec.writeBoolean(out, true);
            EncodedDataCodec.writeString(out, lockingPrincipal.get());
        } else {
            EncodedDataCodec.writeBoolean(out, false);
        }
    }

    private static String readLockedPrincipal(InputStream in) throws IOException {
        return EncodedDataCodec.readBoolean(in) ? EncodedDataCodec.readString(in) : null;
    }

    @FunctionalInterface
    private static interface LockedPrincipalWriter
    extends WriteSerialiser<SecurityControl.Role> {
    }

    @FunctionalInterface
    private static interface LockedPrincipalReader
    extends ReadSerialiser<String> {
    }
}

