/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.security.common;

import com.pushtechnology.diffusion.client.features.control.clients.SecurityControl;
import com.pushtechnology.diffusion.client.types.GlobalPermission;
import com.pushtechnology.diffusion.client.types.PathPermission;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.jcip.annotations.Immutable;

@Immutable
public final class RoleImpl
implements SecurityControl.Role {
    private final String theName;
    private final Set<GlobalPermission> theGlobalPermissions;
    private final Set<PathPermission> theDefaultPathPermissions;
    private final Map<String, Set<PathPermission>> thePathPermissions;
    private final Set<String> theIncludedRoles;
    private final String lockingPrincipal;

    public RoleImpl(String name, Set<GlobalPermission> globalPermissions, Set<PathPermission> defaultPathPermissions, Map<String, ? extends Set<PathPermission>> pathPermissions, Set<String> includedRoles, String lockingPrincipal) {
        this.theName = Objects.requireNonNull(name);
        this.theGlobalPermissions = globalPermissions;
        this.theDefaultPathPermissions = defaultPathPermissions;
        this.thePathPermissions = Collections.unmodifiableMap(pathPermissions);
        this.theIncludedRoles = includedRoles;
        this.lockingPrincipal = lockingPrincipal;
    }

    @Override
    public String getName() {
        return this.theName;
    }

    @Override
    public Set<GlobalPermission> getGlobalPermissions() {
        return this.theGlobalPermissions;
    }

    @Override
    public Set<PathPermission> getDefaultPathPermissions() {
        return this.theDefaultPathPermissions;
    }

    @Override
    public Map<String, Set<PathPermission>> getPathPermissions() {
        return this.thePathPermissions;
    }

    @Override
    public Set<String> getIncludedRoles() {
        return this.theIncludedRoles;
    }

    @Override
    public Optional<String> getLockingPrincipal() {
        return Optional.ofNullable(this.lockingPrincipal);
    }

    public int hashCode() {
        return Objects.hash(this.theName, this.theGlobalPermissions, this.theDefaultPathPermissions, this.thePathPermissions, this.theIncludedRoles, this.lockingPrincipal);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RoleImpl other = (RoleImpl)obj;
        return this.theName.equals(other.theName) && this.theGlobalPermissions.equals(other.theGlobalPermissions) && this.theDefaultPathPermissions.equals(other.theDefaultPathPermissions) && this.thePathPermissions.equals(other.thePathPermissions) && this.theIncludedRoles.equals(other.theIncludedRoles) && Objects.equals(this.lockingPrincipal, other.lockingPrincipal);
    }

    public String toString() {
        return "Name=" + this.theName + ", Global Permissions=" + this.theGlobalPermissions + ", Default Path Permissions=" + this.theDefaultPathPermissions + ", Path Permissions=" + this.thePathPermissions + ", Included Roles=" + this.theIncludedRoles + ", Locking Principal=" + this.lockingPrincipal;
    }
}

