/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.security.common;

import com.pushtechnology.diffusion.client.features.control.clients.SystemAuthenticationControl;
import com.pushtechnology.diffusion.client.types.serialisation.EnumConverter;
import com.pushtechnology.diffusion.collections.ImmutableSet;
import com.pushtechnology.diffusion.command.annotations.CommandSerialiser;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import com.pushtechnology.diffusion.security.common.Protocol4SystemPrincipalSerialiser;
import com.pushtechnology.diffusion.security.common.SystemAuthenticationConfigurationImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import net.jcip.annotations.Immutable;

@Immutable
@CommandSerialiser(spec="protocol4-system-authentication-configuration", valueType=SystemAuthenticationControl.SystemAuthenticationConfiguration.class)
public final class Protocol4SystemAuthenticationConfigurationSerialiser
extends AbstractSerialiser<SystemAuthenticationControl.SystemAuthenticationConfiguration> {
    private static final EnumConverter<SystemAuthenticationControl.AnonymousConnectionAction> ACTION_CONVERTER = new EnumConverter.Builder<SystemAuthenticationControl.AnonymousConnectionAction>(SystemAuthenticationControl.AnonymousConnectionAction.class).bimap(0, SystemAuthenticationControl.AnonymousConnectionAction.ALLOW).bimap(1, SystemAuthenticationControl.AnonymousConnectionAction.DENY).bimap(2, SystemAuthenticationControl.AnonymousConnectionAction.ABSTAIN).build();
    private final Protocol4SystemPrincipalSerialiser principalSerialiser;

    public Protocol4SystemAuthenticationConfigurationSerialiser(Protocol4SystemPrincipalSerialiser principalSerialiser) {
        this.principalSerialiser = principalSerialiser;
    }

    @Override
    public void write(OutputStream out, SystemAuthenticationControl.SystemAuthenticationConfiguration value) throws IOException {
        Protocol4SystemAuthenticationConfigurationSerialiser.writeCollection(out, this.principalSerialiser, value.getPrincipals());
        EncodedDataCodec.writeByte(out, ACTION_CONVERTER.toByte(value.getAnonymousAction()));
        Protocol4SystemAuthenticationConfigurationSerialiser.writeStrings(out, value.getRolesForAnonymousSessions());
    }

    @Override
    protected SystemAuthenticationControl.SystemAuthenticationConfiguration readUnchecked(InputStream in) throws IOException {
        List<SystemAuthenticationControl.SystemPrincipal> principals = Protocol4SystemAuthenticationConfigurationSerialiser.readList(in, this.principalSerialiser);
        SystemAuthenticationControl.AnonymousConnectionAction action = ACTION_CONVERTER.fromByte(EncodedDataCodec.readByte(in));
        ImmutableSet<String> roles = ImmutableSet.from(Protocol4SystemAuthenticationConfigurationSerialiser.readStrings(in));
        return new SystemAuthenticationConfigurationImpl(principals, action, roles);
    }
}

