/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.security.common;

import com.pushtechnology.diffusion.client.features.control.clients.SystemAuthenticationControl;
import com.pushtechnology.diffusion.client.types.serialisation.EnumConverter;
import com.pushtechnology.diffusion.collections.ImmutableSet;
import com.pushtechnology.diffusion.command.annotations.CommandSerialiser;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import com.pushtechnology.diffusion.security.common.Protocol17SystemPrincipalSerialiser;
import com.pushtechnology.diffusion.security.common.SessionPropertyValidationSerialiser;
import com.pushtechnology.diffusion.security.common.SystemAuthenticationConfigurationImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
@CommandSerialiser(spec="protocol18-system-authentication-configuration", valueType=SystemAuthenticationControl.SystemAuthenticationConfiguration.class)
public final class Protocol18SystemAuthenticationConfigurationSerialiser
extends AbstractSerialiser<SystemAuthenticationControl.SystemAuthenticationConfiguration> {
    private static final EnumConverter<SystemAuthenticationControl.AnonymousConnectionAction> ACTION_CONVERTER = new EnumConverter.Builder<SystemAuthenticationControl.AnonymousConnectionAction>(SystemAuthenticationControl.AnonymousConnectionAction.class).bimap(0, SystemAuthenticationControl.AnonymousConnectionAction.ALLOW).bimap(1, SystemAuthenticationControl.AnonymousConnectionAction.DENY).bimap(2, SystemAuthenticationControl.AnonymousConnectionAction.ABSTAIN).build();
    private final Protocol17SystemPrincipalSerialiser principalSerialiser;
    private final SessionPropertyValidationSerialiser propertyValidationSerialiser;

    public Protocol18SystemAuthenticationConfigurationSerialiser(Protocol17SystemPrincipalSerialiser principalSerialiser, SessionPropertyValidationSerialiser propertyValidationSerialiser) {
        this.principalSerialiser = principalSerialiser;
        this.propertyValidationSerialiser = propertyValidationSerialiser;
    }

    @Override
    public void write(OutputStream out, SystemAuthenticationControl.SystemAuthenticationConfiguration value) throws IOException {
        Protocol18SystemAuthenticationConfigurationSerialiser.writeCollection(out, this.principalSerialiser, value.getPrincipals());
        EncodedDataCodec.writeByte(out, ACTION_CONVERTER.toByte(value.getAnonymousAction()));
        Protocol18SystemAuthenticationConfigurationSerialiser.writeStrings(out, value.getRolesForAnonymousSessions());
        Protocol18SystemAuthenticationConfigurationSerialiser.writeMap(out, EncodedDataCodec::writeString, this.propertyValidationSerialiser, value.getTrustedClientProposedProperties());
    }

    @Override
    protected SystemAuthenticationControl.SystemAuthenticationConfiguration readUnchecked(InputStream in) throws IOException {
        List<SystemAuthenticationControl.SystemPrincipal> principals = Protocol18SystemAuthenticationConfigurationSerialiser.readList(in, this.principalSerialiser);
        SystemAuthenticationControl.AnonymousConnectionAction action = ACTION_CONVERTER.fromByte(EncodedDataCodec.readByte(in));
        ImmutableSet<String> roles = ImmutableSet.from(Protocol18SystemAuthenticationConfigurationSerialiser.readStrings(in));
        Map<String, SystemAuthenticationControl.SessionPropertyValidation> properties = Protocol18SystemAuthenticationConfigurationSerialiser.readMap(in, EncodedDataCodec::readString, this.propertyValidationSerialiser);
        return new SystemAuthenticationConfigurationImpl(principals, action, roles, properties);
    }
}

