/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.security.authorisation.model;

import com.pushtechnology.diffusion.collections.ImmutableSet;
import com.pushtechnology.diffusion.command.annotations.CommandSerialiser;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import com.pushtechnology.diffusion.security.authorisation.model.AuthenticatedPrincipal;
import com.pushtechnology.diffusion.security.authorisation.model.AuthenticatedPrincipalImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import net.jcip.annotations.Immutable;

@Immutable
@CommandSerialiser(spec="authenticated-principal", valueType=AuthenticatedPrincipal.class)
public final class AuthenticatedPrincipalSerialiser
extends AbstractSerialiser<AuthenticatedPrincipal> {
    @Override
    public void write(OutputStream out, AuthenticatedPrincipal value) throws IOException {
        EncodedDataCodec.writeString(out, value.getPrincipal());
        AuthenticatedPrincipalSerialiser.writeCollection(out, EncodedDataCodec::writeString, value.getAssignedRoles());
    }

    @Override
    protected AuthenticatedPrincipal readUnchecked(InputStream in) throws IOException {
        String principal = EncodedDataCodec.readString(in);
        List<String> roles = AuthenticatedPrincipalSerialiser.readList(in, EncodedDataCodec::readString);
        return new AuthenticatedPrincipalImpl(principal, ImmutableSet.from(roles));
    }
}

