/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.reports;

import com.pushtechnology.diffusion.reports.Record;
import com.pushtechnology.diffusion.reports.ReportWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public final class RecordReport<F extends Enum<F>>
implements Record<F> {
    private final String[] data;
    private final ReportWriter report;
    private int recordCount = -1;

    public RecordReport(Class<F> fields, ReportWriter report) throws IOException {
        this.report = report;
        Enum[] headers = (Enum[])fields.getEnumConstants();
        this.data = new String[headers.length];
        for (Enum h : headers) {
            this.set(h, h.name());
        }
        this.nextRecord();
    }

    @Override
    public void set(F field, String value) {
        this.data[((Enum)field).ordinal()] = value;
    }

    @Override
    public void set(F field, long value) {
        this.set(field, Long.toString(value));
    }

    @Override
    public void set(F field, boolean value) {
        this.set(field, Boolean.toString(value));
    }

    @Override
    public void set(F field, Object value) {
        this.set(field, Objects.toString(value));
    }

    public void nextRecord() throws IOException {
        this.report.writeRecord(this.data);
        Arrays.fill(this.data, null);
        ++this.recordCount;
    }

    public int getRecordCount() {
        return this.recordCount;
    }
}

