/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.multiplexer.lockfree;

import com.pushtechnology.diffusion.exceptions.DiffusionInterruptedException;
import com.pushtechnology.diffusion.lockfree.utilities.BackOffIdleStrategy;
import com.pushtechnology.diffusion.logs.i18n.I18nLogger;
import com.pushtechnology.diffusion.multiplexer.MultiplexerCallerPriority;
import com.pushtechnology.diffusion.multiplexer.MultiplexerEvent;
import com.pushtechnology.diffusion.multiplexer.MultiplexerState;
import com.pushtechnology.diffusion.multiplexer.impl.AbstractMultiplexer;
import com.pushtechnology.diffusion.multiplexer.impl.MultiplexerRecorder;
import com.pushtechnology.diffusion.multiplexer.impl.MultiplexerStateImpl;
import com.pushtechnology.diffusion.threads.MultiplexerOnly;
import com.pushtechnology.diffusion.utils.ConfigurationUtils;
import com.pushtechnology.repackaged.jctools.queues.MessagePassingQueue;
import com.pushtechnology.repackaged.jctools.queues.MpscBlockingConsumerArrayQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.NotThreadSafe;
import org.slf4j.Logger;

@NotThreadSafe
public class LockFreeMultiplexer<T extends MultiplexerStateImpl>
extends AbstractMultiplexer<T> {
    private static final double THRESHOLD_BLOCK = ConfigurationUtils.getDoubleSystemProperty("diffusion.multiplexer.priority.threshold", 0.6);
    private static final int EVENT_PROCESSING_THRESHOLD_MS = ConfigurationUtils.getIntegerSystemProperty("diffusion.multiplexer.eventProcessingThreshold", 500);
    private static final int MINIMUM_EVENT_BATCH = ConfigurationUtils.getIntegerSystemProperty("diffusion.multiplexer.minimumEvents", 100);
    private static final int MAXIMUM_EVENT_BATCH = ConfigurationUtils.getIntegerSystemProperty("diffusion.multiplexer.maximumEvents", 100000);
    private static final Logger LOG = I18nLogger.getLogger(LockFreeMultiplexer.class);
    private static final BackOffIdleStrategy WAIT = new BackOffIdleStrategy();
    private final MpscBlockingConsumerArrayQueue<MultiplexerEvent<MultiplexerState>> eventQueue;
    private final int lowerThreshold;
    private final int capacity;
    @MultiplexerOnly
    private int eventLimit = MAXIMUM_EVENT_BATCH;

    public LockFreeMultiplexer(T multiplexerState, int qSize, Executor backgroundThreadPool, boolean daemonThread) {
        super(multiplexerState, backgroundThreadPool, daemonThread);
        this.eventQueue = new MpscBlockingConsumerArrayQueue(qSize);
        this.capacity = qSize;
        this.lowerThreshold = (int)((double)this.capacity * THRESHOLD_BLOCK);
    }

    public final int getEventQueueSize() {
        return this.eventQueue.size();
    }

    @Override
    protected final void enqueue(MultiplexerEvent<MultiplexerState> event) {
        if (!this.eventQueue.offerIfBelowThreshold(event, this.lowerThreshold)) {
            this.handleQueueOverThreshold(event);
        }
    }

    private void handleQueueOverThreshold(MultiplexerEvent<MultiplexerState> event) {
        if (MultiplexerCallerPriority.get() == MultiplexerCallerPriority.Priority.STANDARD) {
            this.handleQueueFull(event, this.lowerThreshold);
        } else if (!this.eventQueue.offerIfBelowThreshold(event, this.capacity)) {
            this.handleQueueFull(event, this.capacity);
        }
    }

    private void handleQueueFull(MultiplexerEvent<MultiplexerState> event, int threshold) {
        if (this.isInitialising()) {
            LOG.error("MULTIPLEXER_OVERFLOW", (Object)this);
            throw new IllegalStateException("Multiplexer overflow");
        }
        int idleCounter = 0;
        while (!this.isStopped()) {
            if (this.eventQueue.offerIfBelowThreshold(event, threshold)) {
                return;
            }
            if (idleCounter == 100) {
                LOG.info("MULTIPLEXER_EVENT_DELAYED", (Object)this);
            } else if (idleCounter == 1000) {
                LOG.warn("MULTIPLEXER_EVENT_MORE_DELAYED", (Object)this);
            }
            idleCounter = WAIT.idle(idleCounter);
        }
        LockFreeMultiplexer.cancelEvent(event);
    }

    private boolean processEvents(MultiplexerRecorder recorder, long timeoutNanos) {
        MultiplexerEvent<MultiplexerState> firstEvent = timeoutNanos == 0L ? this.pollEvent() : this.pollEvent(timeoutNanos);
        recorder.updateTime();
        if (firstEvent == null) {
            return false;
        }
        this.processEvent(firstEvent);
        return this.processRemainingEvents(recorder);
    }

    private MultiplexerEvent<MultiplexerState> pollEvent() {
        return this.eventQueue.poll();
    }

    private MultiplexerEvent<MultiplexerState> pollEvent(long timeoutNanos) {
        int idleCounter = 0;
        while (idleCounter < WAIT.blockingPollThreshold()) {
            MultiplexerEvent<MultiplexerState> event = this.pollEvent();
            if (event != null) {
                return event;
            }
            idleCounter = WAIT.idle(idleCounter);
        }
        try {
            return this.eventQueue.poll(timeoutNanos, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            throw new DiffusionInterruptedException(e);
        }
    }

    private boolean processRemainingEvents(MultiplexerRecorder recorder) {
        boolean limited;
        int count;
        int limit = this.eventLimit;
        for (count = 1; count < limit; ++count) {
            if (this.isStopped()) {
                throw new DiffusionInterruptedException();
            }
            MultiplexerEvent<MultiplexerState> event = this.eventQueue.relaxedPoll();
            if (event == null) break;
            this.processEvent(event);
        }
        long time = recorder.eventsProcessed(count);
        boolean bl = limited = count == limit;
        if (time > (long)EVENT_PROCESSING_THRESHOLD_MS) {
            this.eventLimit = Math.max(count >> 1, MINIMUM_EVENT_BATCH);
        } else if (limited) {
            this.eventLimit += Math.min(limit >> 1, MAXIMUM_EVENT_BATCH - limit);
        }
        return limited;
    }

    @Override
    protected final void runProcessing() {
        long timeoutNanos = Long.MAX_VALUE;
        Object state = this.getMultiplexerState();
        MultiplexerRecorder recorder = ((MultiplexerStateImpl)state).getMultiplexerRecorder();
        while (true) {
            recorder.startCycle();
            boolean hasMore = this.processEvents(recorder, timeoutNanos);
            timeoutNanos = ((MultiplexerStateImpl)state).processClient();
            boolean idle = !hasMore && timeoutNanos > 0L;
            timeoutNanos = Math.min(timeoutNanos, this.postProcess(idle, recorder));
            recorder.endCycle(idle);
        }
    }

    @Override
    protected final void drainAndCancel() {
        this.eventQueue.drain((MessagePassingQueue.Consumer<MultiplexerEvent<MultiplexerState>>)((MessagePassingQueue.Consumer<MultiplexerEvent>)AbstractMultiplexer::cancelEvent));
    }

    protected long postProcess(boolean idle, MultiplexerRecorder recorder) {
        return Long.MAX_VALUE;
    }
}

