/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.multiplexer.impl;

import com.pushtechnology.diffusion.collections.ExpandableArray;
import com.pushtechnology.diffusion.logs.i18n.I18nLogger;
import com.pushtechnology.diffusion.multiplexer.MultiplexerClientState;
import com.pushtechnology.diffusion.multiplexer.MultiplexerState;
import com.pushtechnology.diffusion.multiplexer.impl.CacheLinePadding;
import com.pushtechnology.diffusion.multiplexer.impl.ClientTimerWheel;
import com.pushtechnology.diffusion.multiplexer.impl.IntegerPool;
import com.pushtechnology.diffusion.multiplexer.impl.MultiplexerRecorder;
import com.pushtechnology.diffusion.threads.MultiplexerOnly;
import com.pushtechnology.diffusion.utils.ConfigurationUtils;
import com.pushtechnology.diffusion.utils.bytebuffer.DirectByteBufferPool;
import com.pushtechnology.diffusion.utils.bytebuffer.MultiplexerByteBufferPool;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.NotThreadSafe;
import org.slf4j.Logger;

@NotThreadSafe
@MultiplexerOnly
public class MultiplexerStateImpl
extends CacheLinePadding
implements MultiplexerState {
    private static final Logger LOG = I18nLogger.getLogger(MultiplexerStateImpl.class);
    private static final int MAXIMUM_SUBSCRIBERS = Integer.MAX_VALUE;
    private static final int MAXIMUM_RECOVERY_TRIM_TIME_MS = ConfigurationUtils.getIntegerSystemProperty("diffusion.recovery.trim_time", (int)TimeUnit.MILLISECONDS.convert(5L, TimeUnit.MINUTES));
    private final MultiplexerByteBufferPool bufferPool = new MultiplexerByteBufferPool();
    private final Deque<MultiplexerClientState> processingQueue = new ArrayDeque<MultiplexerClientState>();
    private final IntegerPool clientIdPool = new IntegerPool(Integer.MAX_VALUE);
    private final ExpandableArray<MultiplexerClientState> clients = new ExpandableArray();
    private final ClientTimerWheel recoveryBufferTimer;
    private final int maximumRecoveryTrimTimeMS;
    private final String multiplexerName;
    private final ClientTimerWheel.ExpiryCallback<MultiplexerClientState> trimRecoveryBuffer = (n, c) -> c.trimRecoveryBuffer(this, n);
    private final MultiplexerRecorder recorder;

    public static MultiplexerStateImpl createClientMultiplexerState(MultiplexerRecorder recorder) {
        return new MultiplexerStateImpl("ClientMultiplexer", recorder);
    }

    protected MultiplexerStateImpl(String multiplexerName, MultiplexerRecorder recorder) {
        this(multiplexerName, recorder, MAXIMUM_RECOVERY_TRIM_TIME_MS);
    }

    MultiplexerStateImpl(String multiplexerName, MultiplexerRecorder recorder, int maximumRecoveryTrimTimeMS) {
        this.multiplexerName = multiplexerName;
        this.maximumRecoveryTrimTimeMS = maximumRecoveryTrimTimeMS;
        this.recorder = recorder;
        this.recoveryBufferTimer = new ClientTimerWheel(maximumRecoveryTrimTimeMS >> 12, 12);
    }

    public final String getMultiplexerName() {
        return this.multiplexerName;
    }

    protected final ExpandableArray<MultiplexerClientState> clients() {
        return this.clients;
    }

    protected final MultiplexerClientState getClient(int id) {
        return this.clients().getUnchecked(id);
    }

    protected final int getPeakClientId() {
        return this.clientIdPool.getPeak();
    }

    @Override
    public int register(MultiplexerClientState client) {
        assert (client.getIdentity() == -1);
        int id = this.clientIdPool.allocate();
        this.clients.set(id, client);
        return id;
    }

    @Override
    public void unregister(int identity) {
        this.clientIdPool.recycle(identity);
        this.clients.set(identity, null);
    }

    final MultiplexerClientState pollClientForProcessing() {
        return this.processingQueue.poll();
    }

    @Override
    public final long getLastTime() {
        return this.recorder.getLastTime();
    }

    @Override
    public final long processClient() {
        long now = this.getLastTime();
        MultiplexerClientState client = this.pollClientForProcessing();
        if (client != null && client.requiresProcessing()) {
            try {
                client.process(this, now);
                this.recorder.clientsProcessed(1);
            }
            catch (RuntimeException e) {
                LOG.warn("MULTIPLEXER_ERROR_PROCESSING_CLIENT", (Object)client, (Object)e);
            }
        }
        return this.queueDelayedClientsForProcessing(now);
    }

    @Override
    public void queueForProcessing(MultiplexerClientState client) {
        if (client.markForProcessing()) {
            this.processingQueue.add(client);
        }
    }

    protected long queueDelayedClientsForProcessing(long now) {
        return Math.min(TimeUnit.MILLISECONDS.toNanos(this.recoveryBufferTimer.drainExpired(now, this.clients(), this.trimRecoveryBuffer)), this.processingQueue.isEmpty() ? Long.MAX_VALUE : 0L);
    }

    public final void destroy() {
        this.bufferPool.destroy();
    }

    @Override
    public final DirectByteBufferPool getDirectByteBufferPool() {
        return this.bufferPool;
    }

    @Override
    public void trimRecoveryBufferAfter(int delay, MultiplexerClientState client) {
        int identity = client.getIdentity();
        assert (identity >= 0) : client;
        this.recoveryBufferTimer.add(identity, delay);
    }

    @Override
    public final int getMaximumRecoveryTrimTime() {
        return this.maximumRecoveryTrimTimeMS;
    }

    public final MultiplexerRecorder getMultiplexerRecorder() {
        return this.recorder;
    }
}

