/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.multiplexer.impl;

import com.pushtechnology.diffusion.collections.ExpandableArray;
import com.pushtechnology.diffusion.collections.UnsafeBitSetAccess;
import com.pushtechnology.diffusion.multiplexer.impl.CacheLinePadding;
import com.pushtechnology.diffusion.utils.math.DiffusionMath;
import java.util.BitSet;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public final class ClientTimerWheel
extends CacheLinePadding {
    public static final ClientTimerWheel EMPTY = new ClientTimerWheel(0, 0);
    private final int granularity;
    private final int mask;
    private final BitSet[] slots;
    private int position = 0;
    private long lastExpired = 0L;
    private long cachedNextTime = Long.MAX_VALUE;

    public ClientTimerWheel(int timeoutSlots, int granularity) {
        if (granularity < 0 || granularity > 64) {
            throw new IllegalArgumentException("unsupported granularity: " + granularity);
        }
        this.granularity = granularity;
        int numberOfSlots = timeoutSlots == 0 ? 0 : DiffusionMath.findNextPowerOfTwo(timeoutSlots + 1);
        this.slots = new BitSet[numberOfSlots];
        this.mask = numberOfSlots - 1;
        for (int i = 0; i < numberOfSlots; ++i) {
            this.slots[i] = new BitSet();
        }
        if (numberOfSlots != 0) {
            this.cachedNextTime = -1L;
        }
    }

    public void add(int clientIdentity, long delay) {
        int s = this.timeToSlots(delay);
        if (s >= this.slots.length) {
            throw new IllegalArgumentException("delay=" + delay + " too large for " + String.valueOf(this));
        }
        this.slot(this.position + s).set(clientIdentity);
        this.cachedNextTime = Math.min(delay, this.cachedNextTime);
    }

    public <E> long drainExpired(long now, ExpandableArray<E> clientMap, ExpiryCallback<? super E> callback) {
        if (this.cachedNextTime == Long.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        int oldPosition = this.position;
        int numberOfSlots = this.timeToSlots(now - this.lastExpired);
        if (numberOfSlots == 0 && this.slots[oldPosition].isEmpty()) {
            return this.cachedNextTime;
        }
        return this.drain(now, clientMap, callback, oldPosition, numberOfSlots);
    }

    private <E> long drain(long now, ExpandableArray<E> clientMap, ExpiryCallback<? super E> callback, int oldPosition, int numberOfSlots) {
        long nextTime;
        int newPosition = oldPosition + Math.max(0, Math.min(this.slots.length, numberOfSlots));
        this.position = newPosition & this.mask;
        this.lastExpired = now;
        for (int i = oldPosition; i <= newPosition; ++i) {
            BitSet s = this.slot(i);
            UnsafeBitSetAccess.forEach(s, j -> {
                Object client = clientMap.getUnchecked(j);
                if (client != null) {
                    callback.onExpired(now, (Object)client);
                }
            });
            s.clear();
        }
        this.cachedNextTime = nextTime = this.nextTime(oldPosition, newPosition);
        return nextTime;
    }

    private long nextTime(int oldPosition, int newPosition) {
        for (int i = newPosition + 1; i < oldPosition + this.slots.length; ++i) {
            if (this.slot(i).isEmpty()) continue;
            return this.slotsToTime(i - newPosition);
        }
        return Long.MAX_VALUE;
    }

    private BitSet slot(int index) {
        return this.slots[index & this.mask];
    }

    private int timeToSlots(long delta) {
        return (int)(delta >> this.granularity);
    }

    private long slotsToTime(int slot) {
        return (long)slot << this.granularity;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[slots=" + this.slots.length + " granularity=" + this.granularity + "]";
    }

    @FunctionalInterface
    public static interface ExpiryCallback<T> {
        public void onExpired(long var1, T var3);
    }
}

