/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.multiplexer.impl;

import com.pushtechnology.diffusion.exceptions.DiffusionInterruptedException;
import com.pushtechnology.diffusion.logs.i18n.I18nLogger;
import com.pushtechnology.diffusion.multiplexer.CancellableMultiplexerEvent;
import com.pushtechnology.diffusion.multiplexer.Multiplexer;
import com.pushtechnology.diffusion.multiplexer.MultiplexerCallerPriority;
import com.pushtechnology.diffusion.multiplexer.MultiplexerEvent;
import com.pushtechnology.diffusion.multiplexer.MultiplexerState;
import com.pushtechnology.diffusion.multiplexer.impl.CacheLinePadding;
import com.pushtechnology.diffusion.multiplexer.impl.MultiplexerStateImpl;
import com.pushtechnology.diffusion.util.concurrent.threads.ThreadFactoryImpl;
import com.pushtechnology.diffusion.utils.ConfigurationUtils;
import com.pushtechnology.repackaged.picocontainer.Startable;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import net.jcip.annotations.NotThreadSafe;
import org.slf4j.Logger;

@NotThreadSafe
public abstract class AbstractMultiplexer<T extends MultiplexerStateImpl>
extends CacheLinePadding
implements Multiplexer,
Startable {
    private static final Logger LOG = I18nLogger.getLogger(AbstractMultiplexer.class);
    private static final AtomicReferenceFieldUpdater<AbstractMultiplexer, RunState> STATE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(AbstractMultiplexer.class, RunState.class, "runState");
    private static long shutdownTimeout = ConfigurationUtils.getLongSystemProperty("diffusion.multiplexer.shutdown_timeout", TimeUnit.SECONDS.toMillis(15L));
    private final T multiplexerState;
    private final Executor backgroundThreadPool;
    private final Thread thread;
    private volatile RunState runState = RunState.INITIAL;

    protected AbstractMultiplexer(T multiplexerState, Executor backgroundThreadPool, boolean daemonThread) {
        this.multiplexerState = multiplexerState;
        this.backgroundThreadPool = backgroundThreadPool;
        this.thread = new ThreadFactoryImpl(((MultiplexerStateImpl)multiplexerState).getMultiplexerName()).newThread(new MultiplexerRunnable());
        this.thread.setDaemon(daemonThread);
    }

    @Override
    public final void start() {
        if (!this.casRunState(RunState.INITIAL, RunState.RUNNING)) {
            return;
        }
        this.thread.start();
    }

    @Override
    public final void stop() {
        RunState previousState = this.setRunState(RunState.STOPPED);
        this.thread.interrupt();
        if (previousState == RunState.RUNNING) {
            try {
                this.thread.join(shutdownTimeout);
            }
            catch (InterruptedException e) {
                throw new DiffusionInterruptedException(e);
            }
        }
        if (this.thread.isAlive()) {
            StuckMultiplexer e = new StuckMultiplexer(this.thread.getStackTrace());
            LOG.error("MULTIPLEXER_FAILED_TO_STOP", (Object)this, (Object)e);
        }
    }

    @Override
    public final void enqueueEvent(MultiplexerEvent<?> event) {
        MultiplexerEvent<MultiplexerState> stateEvent = event;
        if (this.isStopped()) {
            AbstractMultiplexer.cancelEvent(stateEvent);
        } else if (this.isMultiplexerThread()) {
            this.processEvent(stateEvent);
        } else {
            this.enqueue(stateEvent);
        }
    }

    protected abstract void enqueue(MultiplexerEvent<MultiplexerState> var1);

    @Override
    public final void dispatchInNonMultiplexerThread(Runnable runnable) {
        Runnable highPriorityRunnable = () -> {
            try {
                MultiplexerCallerPriority.set(MultiplexerCallerPriority.Priority.HIGH);
                runnable.run();
            }
            finally {
                MultiplexerCallerPriority.set(MultiplexerCallerPriority.Priority.STANDARD);
            }
        };
        if (!this.isMultiplexerThread()) {
            highPriorityRunnable.run();
        } else {
            try {
                this.backgroundThreadPool.execute(highPriorityRunnable);
            }
            catch (RejectedExecutionException e) {
                LOG.error("MULTIPLEXER_EVENT_SCHEDULE_FAILURE", e);
            }
        }
    }

    protected final T getMultiplexerState() {
        return this.multiplexerState;
    }

    protected void processEvent(MultiplexerEvent<MultiplexerState> event) {
        try {
            event.handleEvent((MultiplexerState)this.multiplexerState);
        }
        catch (DiffusionInterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            this.handleEventProcessingException(e);
        }
    }

    public static final void cancelEvent(MultiplexerEvent<?> event) {
        if (event instanceof CancellableMultiplexerEvent) {
            CancellableMultiplexerEvent cancellable = (CancellableMultiplexerEvent)event;
            try {
                cancellable.cancel();
            }
            catch (RuntimeException e) {
                LOG.error("MULTIPLEXER_EVENT_PROCESSOR_ERROR", e);
            }
        }
    }

    protected void handleEventProcessingException(Exception e) {
        LOG.error("MULTIPLEXER_EVENT_PROCESSOR_ERROR", e);
    }

    protected abstract void runProcessing();

    protected abstract void drainAndCancel();

    public final boolean isStopped() {
        return this.runState == RunState.STOPPED;
    }

    protected final boolean isInitialising() {
        return this.runState == RunState.INITIAL;
    }

    protected final boolean isMultiplexerThread() {
        return this.thread == Thread.currentThread();
    }

    protected final Thread getThread() {
        return this.thread;
    }

    private boolean casRunState(RunState expected, RunState nextState) {
        return STATE_UPDATER.compareAndSet(this, expected, nextState);
    }

    private RunState setRunState(RunState newState) {
        return STATE_UPDATER.getAndSet(this, newState);
    }

    public final String toString() {
        return ((MultiplexerStateImpl)this.multiplexerState).getMultiplexerName();
    }

    static void setShutdownTimeout(long t) {
        shutdownTimeout = t;
    }

    private static enum RunState {
        INITIAL,
        RUNNING,
        STOPPED;

    }

    private final class MultiplexerRunnable
    implements Runnable {
        private MultiplexerRunnable() {
        }

        @Override
        public void run() {
            LOG.debug("MULTIPLEXER_STARTED", (Object)AbstractMultiplexer.this);
            try {
                AbstractMultiplexer.this.runProcessing();
            }
            catch (DiffusionInterruptedException e) {
                LOG.debug("Stopping due to interrrupt.", e);
            }
            finally {
                AbstractMultiplexer.this.setRunState(RunState.STOPPED);
                AbstractMultiplexer.this.drainAndCancel();
                ((MultiplexerStateImpl)AbstractMultiplexer.this.multiplexerState).destroy();
            }
        }
    }

    private static class StuckMultiplexer
    extends Exception {
        StuckMultiplexer(StackTraceElement[] trace) {
            super("");
            this.setStackTrace(trace);
        }
    }
}

