/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.multiplexer.client;

import com.pushtechnology.diffusion.multiplexer.Multiplexer;
import com.pushtechnology.diffusion.multiplexer.MultiplexerSource;
import com.pushtechnology.diffusion.multiplexer.impl.LoggingMultiplexerReporter;
import com.pushtechnology.diffusion.multiplexer.impl.MultiplexerRecorder;
import com.pushtechnology.diffusion.multiplexer.impl.MultiplexerStateImpl;
import com.pushtechnology.diffusion.multiplexer.lockfree.LockFreeMultiplexer;
import com.pushtechnology.diffusion.util.concurrent.threads.CommonThreadPools;
import com.pushtechnology.diffusion.utils.ConfigurationUtils;
import com.pushtechnology.repackaged.picocontainer.Startable;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public final class ClientMultiplexerSource
implements MultiplexerSource<Multiplexer>,
Startable {
    private static final int QUEUE_SIZE = ConfigurationUtils.getIntegerSystemProperty("diffusion.clientmultiplexer.queuesize", 131072);
    private static final int REPORTING_THRESHOLD = ConfigurationUtils.getIntegerSystemProperty("diffusion.clientmultiplexer.reportthreshold", 1000);
    @GuardedBy(value="this")
    private LockFreeMultiplexer<MultiplexerStateImpl> multiplexer;
    private final CommonThreadPools threadPools;

    public ClientMultiplexerSource(CommonThreadPools threadPools) {
        this.threadPools = threadPools;
    }

    @Override
    public synchronized void start() {
        MultiplexerRecorder recorder = new MultiplexerRecorder(LoggingMultiplexerReporter.INSTANCE, REPORTING_THRESHOLD);
        this.multiplexer = new LockFreeMultiplexer<MultiplexerStateImpl>(MultiplexerStateImpl.createClientMultiplexerState(recorder), QUEUE_SIZE, this.threadPools.getBackgroundThreadPool(), true);
        this.multiplexer.start();
    }

    @Override
    public synchronized void stop() {
        if (this.multiplexer != null && !this.multiplexer.isStopped()) {
            this.multiplexer.stop();
        }
    }

    @Override
    public synchronized Multiplexer nextMultiplexer() {
        if (this.multiplexer == null || this.multiplexer.isStopped()) {
            throw new IllegalStateException("Not started: " + String.valueOf(this.multiplexer));
        }
        return this.multiplexer;
    }
}

