/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.multiplexer;

import com.pushtechnology.diffusion.multiplexer.Multiplexer;
import com.pushtechnology.diffusion.multiplexer.MultiplexerClient;
import com.pushtechnology.diffusion.multiplexer.MultiplexerClientState;
import com.pushtechnology.diffusion.multiplexer.MultiplexerEvent;
import com.pushtechnology.diffusion.multiplexer.MultiplexerState;
import com.pushtechnology.diffusion.multiplexer.diagnostics.SessionFields;
import com.pushtechnology.diffusion.reports.Record;
import com.pushtechnology.diffusion.threads.MultiplexerOnly;

public abstract class BaseMultiplexerClient<T extends Multiplexer>
implements MultiplexerClient,
MultiplexerClientState {
    private final T multiplexer;
    @MultiplexerOnly
    private int identity = -1;
    @MultiplexerOnly
    private boolean markedForProcessing;

    protected BaseMultiplexerClient(T multiplexer) {
        this.multiplexer = multiplexer;
    }

    protected final T getMultiplexer() {
        return this.multiplexer;
    }

    @Override
    public final void enqueueEvent(MultiplexerEvent<?> e) {
        this.multiplexer.enqueueEvent(e);
    }

    @Override
    @MultiplexerOnly
    public final void register(MultiplexerState state) {
        if (this.identity == -1) {
            this.identity = state.register(this);
        }
    }

    @MultiplexerOnly
    protected final boolean isRegistered() {
        return this.identity >= 0;
    }

    @Override
    @MultiplexerOnly
    public final void unregister(MultiplexerState state) {
        int oldIdentity = this.identity;
        if (oldIdentity >= 0) {
            this.identity = -2;
            state.unregister(oldIdentity);
            this.doUnregister(state);
        }
    }

    @Override
    public final int getIdentity() {
        return this.identity;
    }

    @MultiplexerOnly
    protected void doUnregister(MultiplexerState state) {
    }

    @Override
    @MultiplexerOnly
    public final boolean markForProcessing() {
        if (this.isRegistered()) {
            boolean result = !this.markedForProcessing;
            this.markedForProcessing = true;
            return result;
        }
        return false;
    }

    @Override
    @MultiplexerOnly
    public final boolean requiresProcessing() {
        if (this.isRegistered() && this.markedForProcessing) {
            this.markedForProcessing = false;
            return true;
        }
        return false;
    }

    @Override
    @MultiplexerOnly
    public boolean delaySend(int writeThresholdBytes) {
        return false;
    }

    @Override
    @MultiplexerOnly
    public void trimRecoveryBuffer(MultiplexerState state, long now) {
        throw new UnsupportedOperationException(String.valueOf(this) + " does not support a recovery buffer");
    }

    @Override
    @MultiplexerOnly
    public void diagnosticReport(Record<SessionFields> record) {
        record.set(SessionFields.ID, this.identity);
        record.set(SessionFields.REQUIRES_PROCESSING, this.markedForProcessing);
    }
}

