/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.messagequeue;

import com.pushtechnology.diffusion.message.Message;
import com.pushtechnology.diffusion.messagequeue.RecoveryBuffer;
import com.pushtechnology.diffusion.utils.ConfigurationUtils;
import com.pushtechnology.diffusion.utils.math.DiffusionMath;
import com.pushtechnology.diffusion.utils.unsafe.UnsafeAccess;
import java.util.Arrays;
import java.util.function.Consumer;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public final class RecoveryBufferImpl
implements RecoveryBuffer {
    private static final int TIMESTAMP_ROUNDING = ConfigurationUtils.getIntegerSystemProperty("diffusion.recoveryqueue.timestamp_rounding", 10);
    private final Message[] messages;
    private int tail;
    private int size;
    private boolean expectingFlush = false;
    private static final long SIZE_OFFSET;
    private int timesHead;
    private int timesTail;
    private final long[] times;
    private final int[] indexes;

    public RecoveryBufferImpl(int minimumMessages, int minimumTimeIndex) {
        this.messages = new Message[DiffusionMath.findNextPowerOfTwo(minimumMessages)];
        int timeIndexCapacity = DiffusionMath.findNextPowerOfTwo(minimumTimeIndex);
        this.times = new long[timeIndexCapacity];
        this.indexes = new int[timeIndexCapacity];
        Arrays.fill(this.indexes, -1);
    }

    @Override
    public void put(Message message) {
        this.messages[this.tail] = message;
        this.tail = this.messagesMask(this.tail + 1);
        if (this.size < this.messages.length) {
            this.soSize(this.size + 1);
        } else {
            while (this.indexes[this.timesHead] == this.tail) {
                this.indexes[this.timesHead] = -1;
                this.timesHead = this.indexMask(this.timesHead + 1);
            }
        }
    }

    @Override
    public boolean canRecover(int n) {
        return n >= 0 && n <= this.size;
    }

    @Override
    public void recover(int n, Consumer<Message> consumer) {
        assert (this.canRecover(n)) : n;
        for (int i = n; i > 0; --i) {
            consumer.accept(this.messages[this.messagesMask(this.tail - i)]);
        }
    }

    @Override
    public void clear() {
        Arrays.fill(this.messages, null);
        this.soSize(0);
        Arrays.fill(this.indexes, -1);
        this.timesHead = 0;
        this.timesTail = 0;
    }

    @Override
    public boolean markTime(long timestamp) {
        if (this.size <= 0) {
            return false;
        }
        int h = this.timesHead;
        int t = this.timesTail;
        int firstIndex = this.indexes[h];
        long roundedTimestamp = RecoveryBufferImpl.roundTimestamp(timestamp);
        if (firstIndex >= 0) {
            int indexLast = this.indexMask(t - 1);
            if (this.indexes[indexLast] == this.tail) {
                return this.ensureFlushScheduled();
            }
            if (this.times[indexLast] == roundedTimestamp) {
                this.indexes[indexLast] = this.tail;
                return this.ensureFlushScheduled();
            }
        }
        this.timesTail = this.indexMask(t + 1);
        this.times[t] = roundedTimestamp;
        this.indexes[t] = this.tail;
        if (h == t && firstIndex >= 0) {
            this.removeElements(firstIndex);
            this.timesHead = this.timesTail;
        }
        return this.ensureFlushScheduled();
    }

    private boolean ensureFlushScheduled() {
        boolean wasExpectingFlush = this.expectingFlush;
        this.expectingFlush = true;
        return !wasExpectingFlush;
    }

    @Override
    public boolean flush(long timestamp) {
        if (this.indexes[this.timesHead] < 0) {
            this.expectingFlush = false;
            return false;
        }
        int i = this.timesTail;
        long roundedTimestamp = RecoveryBufferImpl.roundTimestamp(timestamp);
        do {
            boolean needsFlush;
            int previousI = i;
            if (this.times[i = this.indexMask(i - 1)] > roundedTimestamp) continue;
            this.removeElements(this.indexes[i]);
            if (this.timesHead <= previousI) {
                Arrays.fill(this.indexes, this.timesHead, previousI, -1);
            } else {
                Arrays.fill(this.indexes, this.timesHead, this.indexes.length, -1);
                Arrays.fill(this.indexes, 0, previousI, -1);
            }
            this.timesHead = previousI;
            this.expectingFlush = needsFlush = this.indexes[previousI] >= 0;
            return needsFlush;
        } while (i != this.timesHead);
        this.expectingFlush = true;
        return true;
    }

    @Override
    public int size() {
        return UnsafeAccess.UNSAFE.getIntVolatile(this, SIZE_OFFSET);
    }

    private static long roundTimestamp(long timestamp) {
        return timestamp >> TIMESTAMP_ROUNDING;
    }

    private void removeElements(int newElementsHead) {
        int newSize;
        int messagesHead = this.messagesMask(this.tail - this.size);
        if (messagesHead < newElementsHead) {
            Arrays.fill(this.messages, messagesHead, newElementsHead, null);
            newSize = this.size - (newElementsHead - messagesHead);
        } else if (messagesHead > newElementsHead) {
            int l = this.messages.length;
            Arrays.fill(this.messages, messagesHead, l, null);
            Arrays.fill(this.messages, 0, newElementsHead, null);
            newSize = this.size - (l - messagesHead) - newElementsHead;
        } else {
            Arrays.fill(this.messages, null);
            newSize = 0;
        }
        this.soSize(newSize);
    }

    private int messagesMask(int p) {
        return RecoveryBufferImpl.mask(p, this.messages.length);
    }

    private int indexMask(int p) {
        return RecoveryBufferImpl.mask(p, this.times.length);
    }

    private static int mask(int p, int capacity) {
        return p & capacity - 1;
    }

    private void soSize(int newSize) {
        UnsafeAccess.UNSAFE.putOrderedInt(this, SIZE_OFFSET, newSize);
    }

    static {
        try {
            SIZE_OFFSET = UnsafeAccess.UNSAFE.objectFieldOffset(RecoveryBufferImpl.class.getDeclaredField("size"));
        }
        catch (NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

