/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.messagechannel;

import com.pushtechnology.diffusion.comms.connection.ConnectionInfo;
import com.pushtechnology.diffusion.io.nio.MultiplexerExecutor;
import com.pushtechnology.diffusion.io.nio.NonBlockingWritableNetworkChannel;
import com.pushtechnology.diffusion.io.nio.ReadableNetworkChannel;
import com.pushtechnology.diffusion.logs.i18n.I18nLogger;
import com.pushtechnology.diffusion.message.Message;
import com.pushtechnology.diffusion.message.MessageChannel;
import com.pushtechnology.diffusion.message.MessageChannelClosedReason;
import com.pushtechnology.diffusion.message.MessageChannelFeeder;
import com.pushtechnology.diffusion.message.MessageChannelListener;
import com.pushtechnology.diffusion.messagechannel.MessageChannelMultiplexerClient;
import com.pushtechnology.diffusion.multiplexer.MultiplexerState;
import com.pushtechnology.diffusion.threads.MultiplexerOnly;
import com.pushtechnology.diffusion.time.SystemTime;
import com.pushtechnology.diffusion.utils.ConfigurationUtils;
import com.pushtechnology.diffusion.utils.bytebuffer.DirectByteBufferPool;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Consumer;
import org.slf4j.Logger;

public abstract class MessageChannelImpl
implements MessageChannel {
    private static final Logger LOG = I18nLogger.getLogger(MessageChannelImpl.class);
    private static final long MESSAGE_SEND_DELAY_WARN = ConfigurationUtils.getLongSystemProperty("diffusion.message.send_delay_warning_ms", 2000L);
    private static final int READY_TO_SEND = 0;
    private static final int BUSY = 1;
    private static final int CLOSED = 2;
    private final MessageChannelMultiplexerClient multiplexerClient;
    private static final MessageChannelListener NULL_LISTENER = new MessageChannelListener.NullMessageChannelListener(){

        public String toString() {
            return "NULL_LISTENER";
        }
    };
    private final ConnectionInfo connectionInfo;
    private final int outputBufferSize;
    private volatile int outputState = 0;
    private static final AtomicIntegerFieldUpdater<MessageChannelImpl> OUTPUT_STATE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(MessageChannelImpl.class, "outputState");
    private volatile MessageChannelListener listener;
    private volatile Consumer<MessageChannelListener> closeNotifier;

    protected final MessageChannelMultiplexerClient getMultiplexerClient() {
        return this.multiplexerClient;
    }

    protected MessageChannelImpl(ConnectionInfo connectionInfo, int outputBufferSize, MessageChannelMultiplexerClient multiplexerClient, MessageChannelListener listener) {
        this.connectionInfo = connectionInfo;
        this.outputBufferSize = outputBufferSize;
        this.multiplexerClient = multiplexerClient;
        this.listener = listener;
    }

    @Override
    @MultiplexerOnly
    public final void setReadyToSend() {
        boolean result = OUTPUT_STATE_UPDATER.compareAndSet(this, 1, 0);
        if (LOG.isTraceEnabled()) {
            LOG.trace("{}: setReadyToSend -> {}", (Object)this, (Object)result);
        }
    }

    @Override
    @MultiplexerOnly
    public final void setBusy() {
        boolean result = OUTPUT_STATE_UPDATER.compareAndSet(this, 0, 1);
        if (LOG.isTraceEnabled()) {
            LOG.trace("{}: setBusy -> {}", (Object)this, (Object)result);
        }
    }

    private boolean setClosed() {
        boolean result;
        boolean bl = result = OUTPUT_STATE_UPDATER.getAndSet(this, 2) != 2;
        if (LOG.isTraceEnabled()) {
            LOG.trace("{}: setClosed -> {}", (Object)this, (Object)result);
        }
        return result;
    }

    @Override
    @MultiplexerOnly
    public boolean prepareToSend() {
        return this.outputState == 0;
    }

    @Override
    @MultiplexerOnly
    public final boolean isOutputOpen() {
        return this.outputState != 2;
    }

    @Override
    public void setListener(MessageChannelListener listener) {
        this.listener = listener;
    }

    @Override
    public final void removeListener() {
        this.setListener(NULL_LISTENER);
    }

    @Override
    @MultiplexerOnly
    public final int getOutputBufferSize() {
        return this.outputBufferSize;
    }

    @Override
    public final ConnectionInfo getConnectionInfo() {
        return this.connectionInfo;
    }

    @Override
    public final void close(MessageChannelClosedReason reason, Throwable cause) {
        LOG.trace("{}: close({})", new Object[]{this, reason, cause});
        if (this.setClosed()) {
            this.forceCloseConnections();
            this.listener.messageChannelClosed(reason, cause);
            this.removeListener();
        }
    }

    protected void forceCloseConnections() {
        this.getChannel().close();
    }

    protected final void closeInbound(ReadableNetworkChannel readChannel, Runnable onComplete) {
        LOG.trace("{}: closeInbound({})", (Object)this, (Object)readChannel);
        this.multiplexerClient.enqueueEvent(state -> readChannel.nonBlockingCloseInbound(this.multiplexerClient, onComplete));
    }

    @Override
    public void onCloseOutbound(MessageChannelClosedReason reason, Throwable cause) {
        LOG.trace("'{}': onCloseOutbound({})", new Object[]{this, reason, cause});
        this.closeNotifier = l -> l.messageChannelClosed(reason, cause);
    }

    @Override
    public final void onCloseCompleted(MessageChannelClosedReason reason) {
        if (this.setClosed()) {
            Consumer<MessageChannelListener> notifier = this.closeNotifier;
            if (notifier != null) {
                notifier.accept(this.listener);
            } else {
                this.listener.messageChannelClosed(reason, null);
            }
            this.removeListener();
        }
    }

    @Override
    public void requestLocalClose() {
        this.close(MessageChannelClosedReason.LOCAL_CLOSE_REQUESTED, null);
    }

    @Override
    @MultiplexerOnly
    public void closeOutbound(MessageChannelClosedReason reason, MultiplexerExecutor multiplexerExecutor, DirectByteBufferPool directByteBufferPool) {
        this.getChannel().nonBlockingCloseOutbound(directByteBufferPool, multiplexerExecutor).whenComplete((result, ex) -> this.onCloseOutbound(reason, (Throwable)ex));
    }

    @MultiplexerOnly
    protected final void writeBuffer(MultiplexerState state, ByteBuffer outputBuffer, MessageChannelFeeder feeder, MessageChannelListener.SendResult resultType, int messageCount, int billedMessageCount, long startTime, MultiplexerExecutor partialWriteExecutor) {
        this.writeBufferToChannel(this.getChannel(), state, outputBuffer, feeder, resultType, messageCount, billedMessageCount, startTime, partialWriteExecutor);
    }

    @MultiplexerOnly
    protected final void writeBufferToChannel(NonBlockingWritableNetworkChannel channel, MultiplexerState state, ByteBuffer outputBuffer, MessageChannelFeeder feeder, MessageChannelListener.SendResult result, int messageCount, int billedMessageCount, long startTime, MultiplexerExecutor multiplexerExecutor) {
        int bytesToWrite = outputBuffer.remaining();
        try {
            if (channel.nonBlockingWriteImmediate(outputBuffer, state.getDirectByteBufferPool())) {
                this.onWriteComplete(state, result, messageCount, billedMessageCount, bytesToWrite, startTime, multiplexerExecutor);
            } else {
                channel.flushWhenWriteReady(multiplexerExecutor).whenComplete((flushes, e) -> {
                    if (e != null) {
                        this.close(MessageChannelClosedReason.WRITE_ERROR, (Throwable)e);
                    } else {
                        this.onWriteComplete(state, result, messageCount, billedMessageCount, bytesToWrite, startTime, multiplexerExecutor);
                        MessageChannelImpl.logDelayedWrite(feeder, messageCount, bytesToWrite, startTime);
                    }
                });
            }
        }
        catch (IOException e2) {
            this.close(MessageChannelClosedReason.WRITE_ERROR, e2);
        }
    }

    @MultiplexerOnly
    private void onWriteComplete(MultiplexerState state, MessageChannelListener.SendResult result, int messageCount, int billedMessageCount, int bytesWritten, long startTime, MultiplexerExecutor multiplexerExecutor) {
        this.listener.messageSendComplete(state, result, messageCount, billedMessageCount, bytesWritten, startTime);
        if (result == MessageChannelListener.SendResult.ABORT) {
            this.closeOutbound(MessageChannelClosedReason.LOCAL_CLOSE_REQUESTED, multiplexerExecutor, state.getDirectByteBufferPool());
        } else {
            this.writeBufferComplete();
        }
    }

    private static void logDelayedWrite(MessageChannelFeeder channel, int messagesSent, int bytesWritten, long startTime) {
        if (LOG.isWarnEnabled() || LOG.isTraceEnabled()) {
            long took = SystemTime.currentTimeMillis() - startTime;
            if (took > MESSAGE_SEND_DELAY_WARN && LOG.isWarnEnabled()) {
                LOG.warn("MESSAGE_CHANNEL_SEND_DELAY", messagesSent, bytesWritten, channel, took);
            } else {
                LOG.trace("MESSAGE_CHANNEL_SEND_DELAY", messagesSent, bytesWritten, channel, took);
            }
        }
    }

    @MultiplexerOnly
    protected abstract void writeBufferComplete();

    protected abstract NonBlockingWritableNetworkChannel getChannel();

    @Override
    public final boolean isSecure() {
        return this.getChannel().isSecure();
    }

    @Override
    @MultiplexerOnly
    public final void sendMessages(MultiplexerState state, MessageChannelFeeder feeder, long now, MultiplexerExecutor partialWriteExecutor) {
        this.setBusy();
        Message firstMessage = feeder.peekMessage();
        if (firstMessage == null) {
            LOG.trace("Nothing to write");
            this.writeBufferComplete();
            return;
        }
        MessageChannelImpl.removePolled(feeder, firstMessage);
        this.doSendMessages(state, firstMessage, feeder, now, partialWriteExecutor);
    }

    protected final MessageChannelListener getListener() {
        return this.listener;
    }

    @MultiplexerOnly
    protected abstract void doSendMessages(MultiplexerState var1, Message var2, MessageChannelFeeder var3, long var4, MultiplexerExecutor var6);

    @Override
    @MultiplexerOnly
    public void writeResponse(ByteBuffer buffer, DirectByteBufferPool directBufferPool, MultiplexerExecutor partialWriteExecutor) {
        this.setBusy();
        this.getChannel().nonBlockingWrite(buffer, directBufferPool, partialWriteExecutor).whenComplete((result, e) -> {
            if (e != null) {
                this.close(MessageChannelClosedReason.WRITE_ERROR, (Throwable)e);
            } else {
                this.setReadyToSend();
            }
        });
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.outputStateToString() + "]:" + String.valueOf(this.getChannel());
    }

    protected final String outputStateToString() {
        switch (this.outputState) {
            case 0: {
                return "READY_TO_SEND";
            }
            case 1: {
                return "BUSY";
            }
        }
        return "CLOSED";
    }

    protected static void removePolled(MessageChannelFeeder feeder, Message expected) {
        Message removed = feeder.pollMessage();
        assert (removed == expected) : "Expected " + String.valueOf(expected) + ", got " + String.valueOf(removed);
    }

    @Override
    public boolean nonBlockingFlush(DirectByteBufferPool directByteBufferPool) throws IOException {
        try {
            return this.getChannel().nonBlockingFlush(directByteBufferPool);
        }
        catch (IOException e) {
            this.close(MessageChannelClosedReason.WRITE_ERROR, e);
            throw e;
        }
    }
}

