/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.message;

import com.pushtechnology.diffusion.client.callbacks.ErrorReason;
import com.pushtechnology.diffusion.command.sender.ServiceException;
import com.pushtechnology.diffusion.comms.connection.ConnectionInfo;
import com.pushtechnology.diffusion.comms.connection.ProtocolVersion;
import com.pushtechnology.diffusion.io.bytes.ByteBufferIBytes;
import com.pushtechnology.diffusion.io.bytes.IBytes;
import com.pushtechnology.diffusion.io.bytes.IBytesInputStream;
import com.pushtechnology.diffusion.io.bytes.IBytesOutputStream;
import com.pushtechnology.diffusion.io.bytes.IBytesOutputStreamImpl;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.io.serialisation.TrailingBytesWriteSerialiser;
import com.pushtechnology.diffusion.io.serialisation.WriteSerialiser;
import com.pushtechnology.diffusion.message.Message;
import com.pushtechnology.diffusion.message.MessageTypes;
import com.pushtechnology.diffusion.message.ParseMessageException;
import com.pushtechnology.diffusion.utils.io.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import net.jcip.annotations.Immutable;

@Immutable
public abstract class ServiceMessage
implements Message {
    private final IBytes data;

    public static final ServiceMessage parseServiceRequest(ByteBuffer source) {
        return new ServiceRequestMessage(ByteBufferIBytes.wrapBuffer(source));
    }

    public static final ServiceMessage parseServiceResponse(ByteBuffer source) {
        return new ServiceResponseMessage(ByteBufferIBytes.wrapBuffer(source));
    }

    public static final ServiceMessage parseServiceError(ByteBuffer source) {
        return new ServiceErrorMessage(ByteBufferIBytes.wrapBuffer(source));
    }

    public static final ServiceMessage parseProtocol9ServiceResponse(ByteBuffer source) {
        return new Protocol9ServiceResponseMessage(ByteBufferIBytes.wrapBuffer(source));
    }

    public static final ServiceMessage parseProtocol9ServiceError(ByteBuffer source) {
        return new Protocol9ErrorMessage(ByteBufferIBytes.wrapBuffer(source));
    }

    public static final <C> ServiceRequestMessage createRequest(int serviceId, long cid, WriteSerialiser<? super C> commandSerialiser, C command) {
        return new ServiceRequestMessage(ServiceMessage.serialise(serviceId, cid, commandSerialiser, command));
    }

    public static final <C> ServiceMessage createResponse(long cid, WriteSerialiser<? super C> responseSerialiser, C response) {
        IBytesOutputStreamImpl out = IBytesOutputStreamImpl.forThread();
        try {
            EncodedDataCodec.writeInt64(out, cid);
            if (responseSerialiser instanceof TrailingBytesWriteSerialiser) {
                TrailingBytesWriteSerialiser trailingBytesSerialiser = (TrailingBytesWriteSerialiser)responseSerialiser;
                return ServiceMessage.completeTrailingBytesResponse(out, trailingBytesSerialiser, response);
            }
            return ServiceMessage.completeSimpleResponse(out, responseSerialiser, response);
        }
        catch (IOException e) {
            throw new ServiceException("Failed to serialise service message", e);
        }
    }

    private static <C> ServiceMessage completeSimpleResponse(IBytesOutputStream out, WriteSerialiser<C> responseSerialiser, C response) throws IOException {
        responseSerialiser.write(out, response);
        return new ServiceResponseMessage(out.toIBytes());
    }

    private static <C> ServiceMessage completeTrailingBytesResponse(IBytesOutputStream out, TrailingBytesWriteSerialiser<C> responseSerialiser, C response) throws IOException {
        responseSerialiser.writeHead(out, response);
        return new TrailingBytesResponseMessage(out.toIBytes(), responseSerialiser.getTail(response));
    }

    public static final ServiceMessage createError(long cid, ErrorReason reason, String message) {
        IBytesOutputStreamImpl body = IBytesOutputStreamImpl.forThread();
        try {
            EncodedDataCodec.writeInt64(body, cid);
            EncodedDataCodec.writeString(body, message);
            EncodedDataCodec.writeInt32(body, reason.getReasonCode());
        }
        catch (IOException e) {
            throw new ServiceException("Failed to serialise service error message", e);
        }
        return new ServiceErrorMessage(((IBytesOutputStream)body).toIBytes());
    }

    public static final <C> ServiceMessage createProtocol9Response(int serviceId, long cid, WriteSerialiser<? super C> responseSerialiser, C response) {
        return new Protocol9ServiceResponseMessage(ServiceMessage.serialise(serviceId, cid, responseSerialiser, response));
    }

    public static final ServiceMessage createProtocol9Error(int serviceId, long cid, ErrorReason reason, String message) {
        IBytesOutputStreamImpl body = IBytesOutputStreamImpl.forThread();
        try {
            EncodedDataCodec.writeInt32(body, serviceId);
            EncodedDataCodec.writeInt64(body, cid);
            EncodedDataCodec.writeString(body, message);
            EncodedDataCodec.writeInt32(body, reason.getReasonCode());
        }
        catch (IOException e) {
            throw new ServiceException("Failed to serialise service error message", e);
        }
        return new Protocol9ErrorMessage(((IBytesOutputStream)body).toIBytes());
    }

    protected static final <C> IBytes serialise(int serviceId, long cid, WriteSerialiser<? super C> serialiser, C value) {
        IBytesOutputStreamImpl body = IBytesOutputStreamImpl.forThread();
        try {
            EncodedDataCodec.writeInt32(body, serviceId);
            EncodedDataCodec.writeInt64(body, cid);
            serialiser.write(body, value);
        }
        catch (IOException e) {
            throw new ServiceException("Failed to serialise service message", e);
        }
        return ((IBytesOutputStream)body).toIBytes();
    }

    public static final int parseServiceId(InputStream in) throws ParseMessageException {
        try {
            return EncodedDataCodec.readInt32(in);
        }
        catch (IOException e) {
            throw new ParseMessageException("Failed to parse service ID", e);
        }
    }

    public static final long parseConversationId(InputStream in) throws ParseMessageException {
        try {
            return EncodedDataCodec.readInt64(in);
        }
        catch (IOException e) {
            throw new ParseMessageException("Failed to parse conversation ID", e);
        }
    }

    protected ServiceMessage(IBytes data) {
        this.data = data;
    }

    public abstract byte getMessageType();

    @Override
    public int bodySize() {
        return this.data.length();
    }

    @Override
    public final int size(ConnectionInfo connectionInfo) {
        return this.bodySize();
    }

    @Override
    public void write(ByteBuffer buffer, ConnectionInfo connectionInfo) {
        buffer.put(this.getMessageType());
        this.data.copyTo(buffer);
    }

    @Override
    public void writeWithPollingHeader(OutputStream out, ConnectionInfo connectionInfo) throws IOException {
        if (connectionInfo.getProtocolVersion().isAtLeast(ProtocolVersion.PROTOCOL_12_VERSION)) {
            IOUtils.writeIntBigEndian(out, this.bodySize());
            out.write(this.getMessageType());
        } else {
            out.write(this.getMessageType());
            IOUtils.writeIntBigEndian(out, this.bodySize());
        }
        this.data.copyTo(out);
    }

    public IBytes getBody() {
        return this.data;
    }

    public String toString() {
        try {
            IBytesInputStream in = this.data.asInputStream();
            int serviceId = ServiceMessage.parseServiceId(in);
            long cid = ServiceMessage.parseConversationId(in);
            return MessageTypes.getMessageTypeName(this.getMessageType()) + " service id=" + serviceId + " cid=" + cid;
        }
        catch (ParseMessageException e) {
            return "Bad service message: " + e.getMessage();
        }
    }

    public static class ServiceRequestMessage
    extends ServiceMessage {
        protected ServiceRequestMessage(IBytes data) {
            super(data);
        }

        @Override
        public final byte getMessageType() {
            return 0;
        }
    }

    private static class ServiceResponseMessage
    extends ServiceMessage {
        protected ServiceResponseMessage(IBytes data) {
            super(data);
        }

        @Override
        public byte getMessageType() {
            return 6;
        }

        @Override
        public String toString() {
            return this.toString(this.getBody());
        }

        protected final String toString(IBytes head) {
            try {
                IBytesInputStream in = head.asInputStream();
                long cid = ServiceResponseMessage.parseConversationId(in);
                return MessageTypes.getMessageTypeName(this.getMessageType()) + " cid=" + cid;
            }
            catch (ParseMessageException e) {
                return "Bad service message: " + e.getMessage();
            }
        }
    }

    private static final class ServiceErrorMessage
    extends ServiceResponseMessage {
        private ServiceErrorMessage(IBytes data) {
            super(data);
        }

        @Override
        public byte getMessageType() {
            return 7;
        }
    }

    private static final class Protocol9ServiceResponseMessage
    extends ServiceMessage {
        private Protocol9ServiceResponseMessage(IBytes data) {
            super(data);
        }

        @Override
        public byte getMessageType() {
            return 1;
        }
    }

    private static final class Protocol9ErrorMessage
    extends ServiceMessage {
        private Protocol9ErrorMessage(IBytes data) {
            super(data);
        }

        @Override
        public byte getMessageType() {
            return 2;
        }
    }

    private static final class TrailingBytesResponseMessage
    extends ServiceResponseMessage {
        private final IBytes tail;

        private TrailingBytesResponseMessage(IBytes headers, IBytes tail) {
            super(headers);
            this.tail = tail;
        }

        @Override
        public int bodySize() {
            int trailingLength = this.tail.length();
            return super.bodySize() + EncodedDataCodec.lengthOfEncodedInt32(trailingLength) + trailingLength;
        }

        @Override
        public void write(ByteBuffer buffer, ConnectionInfo connectionInfo) {
            super.write(buffer, connectionInfo);
            EncodedDataCodec.writeInt32(buffer, this.tail.length());
            this.tail.copyTo(buffer);
        }

        @Override
        public void writeWithPollingHeader(OutputStream out, ConnectionInfo connectionInfo) throws IOException {
            super.writeWithPollingHeader(out, connectionInfo);
            EncodedDataCodec.writeInt32(out, this.tail.length());
            this.tail.copyTo(out);
        }

        @Override
        public IBytes getBody() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String toString() {
            return this.toString(super.getBody());
        }
    }
}

