/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.message;

import com.pushtechnology.diffusion.comms.connection.ConnectionInfo;
import com.pushtechnology.diffusion.content.encoding.ZlibCompression;
import com.pushtechnology.diffusion.io.bytes.ByteBufferIBytes;
import com.pushtechnology.diffusion.io.bytes.IBytes;
import com.pushtechnology.diffusion.message.Message;
import com.pushtechnology.diffusion.message.MessageEncoding;
import com.pushtechnology.diffusion.message.MessageTypes;
import com.pushtechnology.diffusion.message.ParseMessageException;
import com.pushtechnology.diffusion.utils.ConfigurationUtils;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.zip.DataFormatException;
import net.jcip.annotations.Immutable;

@Immutable
public final class ClientTopicMessage
implements Message {
    private static final boolean DISABLE_DECOMPRESSION = ConfigurationUtils.getBooleanSystemProperty("diffusion.disabledecompression");
    private final IBytes data;
    private final int topicId;
    private final byte messageType;

    public static ClientTopicMessage parse(byte messageType, MessageEncoding encoding, ByteBuffer source) throws ParseMessageException {
        IBytes data;
        int topicId = source.getInt();
        if (encoding == MessageEncoding.ZLIB && !DISABLE_DECOMPRESSION) {
            byte[] bytes = new byte[source.remaining()];
            source.get(bytes);
            try {
                data = ZlibCompression.forThread().decompress(bytes, 0, bytes.length).toIBytes();
            }
            catch (DataFormatException e) {
                throw new ParseMessageException("Failed to decompress message", e);
            }
        } else {
            data = ByteBufferIBytes.wrapBuffer(source);
            source.position(source.limit());
        }
        return new ClientTopicMessage(messageType, topicId, data);
    }

    private ClientTopicMessage(byte messageType, int topicId, IBytes data) {
        this.messageType = messageType;
        this.topicId = topicId;
        this.data = data;
    }

    public byte getMessageType() {
        return this.messageType;
    }

    public int getTopicId() {
        return this.topicId;
    }

    @Override
    public int bodySize() {
        return this.data.length();
    }

    @Override
    public int size(ConnectionInfo connectionInfo) {
        return this.bodySize();
    }

    @Override
    public void write(ByteBuffer buffer, ConnectionInfo connectionInfo) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeWithPollingHeader(OutputStream out, ConnectionInfo connectionInfo) {
        throw new UnsupportedOperationException();
    }

    public IBytes getBodyShared() {
        return this.data;
    }

    public IBytes getBody() {
        return IBytes.toIBytes(this.data.toByteArray());
    }

    public String toString() {
        IBytes bytes = this.data;
        StringBuilder sb = new StringBuilder(256);
        sb.append(MessageTypes.getMessageTypeName(this.messageType));
        sb.append(' ');
        sb.append(bytes.length());
        int maximumBytes = 100;
        sb.append(" bytes [");
        bytes.appendHex(sb, 100);
        if (bytes.length() > 100) {
            sb.append("] ...");
        } else {
            sb.append(']');
        }
        return sb.toString();
    }
}

