/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.java8;

import java.util.concurrent.CompletionException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public final class LambdaCheckedExceptionWorkarounds {
    private LambdaCheckedExceptionWorkarounds() {
    }

    public static <T, E extends Exception> Consumer<T> rethrow(ExceptionalConsumer<T, E> consumer) throws E {
        return t -> {
            try {
                consumer.accept(t);
            }
            catch (Exception exception) {
                LambdaCheckedExceptionWorkarounds.sneakyThrow(exception);
            }
        };
    }

    public static <T, U, E extends Exception> BiConsumer<T, U> rethrow(ExceptionalBiConsumer<T, U, E> consumer) throws E {
        return (t, u) -> {
            try {
                consumer.accept(t, u);
            }
            catch (Exception exception) {
                LambdaCheckedExceptionWorkarounds.sneakyThrow(exception);
            }
        };
    }

    public static <E extends Exception> Runnable rethrow(ExceptionalRunnable<E> consumer) throws E {
        return () -> {
            try {
                consumer.run();
            }
            catch (Exception exception) {
                LambdaCheckedExceptionWorkarounds.sneakyThrow(exception);
            }
        };
    }

    public static <T, R, E extends Exception> Function<T, R> rethrowFunction(ExceptionalFunction<T, R, E> function) throws E {
        return t -> {
            try {
                return function.apply(t);
            }
            catch (Exception exception) {
                LambdaCheckedExceptionWorkarounds.sneakyThrow(exception);
                return null;
            }
        };
    }

    public static <T, U, R, E extends Exception> BiFunction<T, U, R> rethrowFunction(ExceptionalBiFunction<T, U, R, E> function) throws E {
        return (t, u) -> {
            try {
                return function.apply(t, u);
            }
            catch (Exception exception) {
                LambdaCheckedExceptionWorkarounds.sneakyThrow(exception);
                return null;
            }
        };
    }

    public static <T, E extends Exception> Supplier<T> rethrow(ExceptionalSupplier<T, E> supplier) throws E {
        return () -> {
            try {
                return supplier.get();
            }
            catch (Exception exception) {
                LambdaCheckedExceptionWorkarounds.sneakyThrow(exception);
                return null;
            }
        };
    }

    public static <T, U, E extends Exception> Function<T, U> rethrowAsCompletionException(ExceptionalFunction<T, U, E> e) throws CompletionException {
        return t -> {
            try {
                return e.apply(t);
            }
            catch (Exception exception) {
                throw new CompletionException(exception);
            }
        };
    }

    public static <E extends Exception> void sneakyThrow(Exception exception) throws E {
        throw exception;
    }

    @FunctionalInterface
    public static interface ExceptionalConsumer<T, E extends Exception> {
        public void accept(T var1) throws E;
    }

    @FunctionalInterface
    public static interface ExceptionalBiConsumer<T, U, E extends Exception> {
        public void accept(T var1, U var2) throws E;
    }

    @FunctionalInterface
    public static interface ExceptionalRunnable<E extends Exception> {
        public void run() throws E;
    }

    @FunctionalInterface
    public static interface ExceptionalFunction<T, R, E extends Exception> {
        public R apply(T var1) throws E;
    }

    @FunctionalInterface
    public static interface ExceptionalBiFunction<T, U, R, E extends Exception> {
        public R apply(T var1, U var2) throws E;
    }

    @FunctionalInterface
    public static interface ExceptionalSupplier<T, E extends Exception> {
        public T get() throws E;
    }
}

