/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.io.ssl;

import com.pushtechnology.diffusion.utils.JVMSupport;
import com.pushtechnology.diffusion.utils.io.IOUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public final class SSLUtils {
    private SSLUtils() {
    }

    public static SSLContext loadSSLContext(String keystoreFileName, String keystorePassword) throws IOException {
        SSLContext sSLContext;
        block9: {
            if (keystorePassword == null) {
                throw new IOException("Keystore password must be provided for SSL context.");
            }
            KeyStore keyStore = KeyStore.getInstance("JKS");
            char[] keystorePasswordChars = keystorePassword.toCharArray();
            File keystoreFile = new File(keystoreFileName);
            InputStream keyStoreInputStream = Files.newInputStream(keystoreFile.toPath(), new OpenOption[0]);
            try {
                keyStore.load(keyStoreInputStream, keystorePasswordChars);
                IOUtils.closeQuietly(keyStoreInputStream);
                SSLContext context = SSLContext.getInstance("TLS");
                KeyManagerFactory keyManagerFactory = JVMSupport.getKeyManagerFactory();
                keyManagerFactory.init(keyStore, keystorePasswordChars);
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init(keyStore);
                context.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
                sSLContext = context;
                if (keyStoreInputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (keyStoreInputStream != null) {
                        try {
                            keyStoreInputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (GeneralSecurityException e) {
                    throw new IOException(e);
                }
            }
            keyStoreInputStream.close();
        }
        return sSLContext;
    }
}

