/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.io.serialisation.impl;

import com.pushtechnology.diffusion.io.serialisation.SerialisationContext;
import com.pushtechnology.diffusion.io.serialisation.Serialiser;
import com.pushtechnology.repackaged.picocontainer.MutablePicoContainer;
import com.pushtechnology.repackaged.picocontainer.PicoBuilder;
import com.pushtechnology.repackaged.picocontainer.PicoCompositionException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PicoSerialisationContextBuilder {
    private final MutablePicoContainer container = new PicoBuilder().withCaching().withConstructorInjection().build();

    public PicoSerialisationContextBuilder add(Object instance) {
        this.container.addComponent(instance);
        return this;
    }

    public SerialisationContext build() throws PicoCompositionException {
        return new SerialisationContextImpl(this.container.getComponents(Serialiser.class));
    }

    private static final class SerialisationContextImpl
    implements SerialisationContext {
        private final Map<Class<?>, Serialiser<?>> serialiserClasses;

        SerialisationContextImpl(List<Serialiser> serialisers) {
            this.serialiserClasses = new HashMap(serialisers.size());
            for (Serialiser s : serialisers) {
                this.serialiserClasses.put(s.getClass(), s);
            }
        }

        @Override
        public <V> Serialiser<V> getInstance(Class<? extends Serialiser<V>> clazz) {
            Serialiser<?> serialiser = this.serialiserClasses.get(clazz);
            if (serialiser == null) {
                throw new IllegalArgumentException("No serialiser registered for " + clazz.getName());
            }
            return serialiser;
        }

        @Override
        public Collection<Serialiser<?>> serialisers() {
            return Collections.unmodifiableCollection(this.serialiserClasses.values());
        }

        public String toString() {
            return this.serialiserClasses.values().toString();
        }
    }
}

