/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.io.serialisation;

import java.io.IOException;

public interface Option<T> {
    public void accept(Visitor<T> var1);

    public void accept(IOVisitor<T> var1) throws IOException;

    public static class Some<T>
    implements Option<T> {
        private final T value;

        public Some(T value) {
            this.value = value;
        }

        @Override
        public void accept(Visitor<T> visitor) {
            visitor.some(this.value);
        }

        @Override
        public void accept(IOVisitor<T> visitor) throws IOException {
            visitor.some(this.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.value.equals(((Some)o).value);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + String.valueOf(this.value) + "]";
        }
    }

    public static abstract class None<T>
    implements Option<T> {
        @Override
        public void accept(Visitor<T> visitor) {
            visitor.none();
        }

        @Override
        public void accept(IOVisitor<T> visitor) throws IOException {
            visitor.none();
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    public static interface IOVisitor<T> {
        public void some(T var1) throws IOException;

        public void none() throws IOException;
    }

    public static interface Visitor<T> {
        public void some(T var1);

        public void none();
    }
}

