/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.io.selector.lockfree;

import com.pushtechnology.diffusion.io.nio.AbstractUnifiedSelector;
import com.pushtechnology.diffusion.io.nio.SelectedKeyProcessor;
import com.pushtechnology.diffusion.io.selector.SelectorTask;
import com.pushtechnology.diffusion.io.selector.UnifiedSelectorFactory;
import com.pushtechnology.diffusion.io.selector.UnifiedSelectorParameters;
import com.pushtechnology.diffusion.lockfree.utilities.BackOffIdleStrategy;
import com.pushtechnology.diffusion.logs.i18n.I18nLogger;
import com.pushtechnology.diffusion.utils.ConfigurationUtils;
import com.pushtechnology.repackaged.jctools.queues.MessagePassingQueue;
import com.pushtechnology.repackaged.jctools.queues.MpscArrayQueue;
import java.io.IOException;
import java.nio.channels.Selector;
import net.jcip.annotations.Immutable;
import org.slf4j.Logger;

@Immutable
public final class LockFreeSelectorFactory
implements UnifiedSelectorFactory {
    public static final int SERVER_TASK_QUEUE_SIZE = ConfigurationUtils.getIntegerSystemProperty("diffusion.selector.task.queue.size", 131072);
    public static final int CLIENT_TASK_QUEUE_SIZE = ConfigurationUtils.getIntegerSystemProperty("diffusion.selector.task.queue.size", 1024);
    private static final Logger LOG = I18nLogger.getLogger(LockFreeSelectorFactory.class);
    private final int taskQueueSize;
    private final UnifiedSelectorParameters parameters;

    public LockFreeSelectorFactory() {
        this(CLIENT_TASK_QUEUE_SIZE);
    }

    public LockFreeSelectorFactory(int taskQueueSize) {
        this(taskQueueSize, LockFreeSelectorFactory.getDefaultSelectorParameters(ConfigurationUtils.getSystemProperty("os.name", "")));
    }

    LockFreeSelectorFactory(int taskQueueSize, UnifiedSelectorParameters parameters) {
        this.taskQueueSize = taskQueueSize;
        this.parameters = parameters;
    }

    @Override
    public LockFreeUnifiedSelector createUnifiedSelector(String name) {
        return new LockFreeUnifiedSelector(name, new MpscArrayQueue<SelectorTask>(this.taskQueueSize), this.parameters);
    }

    static UnifiedSelectorParameters getDefaultSelectorParameters(String operatingSystemName) {
        if (operatingSystemName.toLowerCase().contains("win")) {
            if (LOG.isInfoEnabled()) {
                LOG.info("LOCK_FREE_WINDOWS_DEFAULT_SELECT_TIMEOUT");
            }
            return UnifiedSelectorParameters.selectTimeout(1L);
        }
        return UnifiedSelectorParameters.SELECT_NOW;
    }

    private static class LockFreeUnifiedSelector
    extends AbstractUnifiedSelector<MpscArrayQueue<SelectorTask>> {
        private static final BackOffIdleStrategy IDLE = new BackOffIdleStrategy();

        LockFreeUnifiedSelector(String name, MpscArrayQueue<SelectorTask> queue, UnifiedSelectorParameters parameters) {
            super(name, queue, parameters);
        }

        @Override
        protected void runProcessing(MpscArrayQueue<SelectorTask> queue, Selector selector, SelectedKeyProcessor keyProcessor, UnifiedSelectorParameters parameters) throws IOException {
            long selectTimeout = parameters.getSelectTimeout();
            int idleCounter = 0;
            MessagePassingQueue.Consumer<SelectorTask> processor = task -> this.processTask(selector, (SelectorTask)task);
            while (true) {
                boolean processedTasks = queue.drain(processor) > 0;
                int selectedKeysCount = selectTimeout < 0L ? selector.selectNow() : selector.select(selectTimeout);
                if (selectedKeysCount > 0) {
                    keyProcessor.handleKeys(selector);
                    idleCounter = 0;
                    continue;
                }
                if (processedTasks) {
                    idleCounter = 0;
                    continue;
                }
                if (parameters.useWakeup()) continue;
                idleCounter = IDLE.idle(idleCounter);
            }
        }

        @Override
        protected void putRequest(MpscArrayQueue<SelectorTask> queue, SelectorTask task) {
            int idleCounter = 0;
            while (this.isRunning() && !queue.offer(task)) {
                idleCounter = IDLE.idle(idleCounter);
            }
        }
    }
}

