/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.io.nio;

import com.pushtechnology.diffusion.util.concurrent.threads.FastThreadLocal;
import java.io.IOException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.Selector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ThreadTemporarySelector {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadTemporarySelector.class);
    private static final FastThreadLocal<Selector> SELECTORS = new FastThreadLocal();

    private ThreadTemporarySelector() {
    }

    static Selector getSelector() throws IOException {
        Selector result = SELECTORS.get();
        if (result != null) {
            return result;
        }
        Selector newSelector = Selector.open();
        SELECTORS.set(newSelector);
        return newSelector;
    }

    static void returnSelector(Selector selector) {
        try {
            selector.selectNow();
            return;
        }
        catch (ClosedSelectorException e) {
            LOG.trace("Selector closed", e);
        }
        catch (IOException e) {
            LOG.trace("Discarding temporary selector", e);
        }
        SELECTORS.remove();
    }
}

