/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.io.nio;

import com.pushtechnology.diffusion.io.nio.KeyAttachment;
import com.pushtechnology.diffusion.io.nio.NIOConnector;
import com.pushtechnology.diffusion.io.nio.SelectedKeyProcessor;
import com.pushtechnology.diffusion.logs.i18n.I18nLogger;
import com.pushtechnology.diffusion.utils.unsafe.UnsafeAccess;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.NotYetBoundException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Set;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.NotThreadSafe;
import org.slf4j.Logger;

@Immutable
final class SelectedKeyProcessorFactory {
    private static final Logger LOG = I18nLogger.getLogger(SelectedKeyProcessorFactory.class);

    private SelectedKeyProcessorFactory() {
    }

    static SelectedKeyProcessor createKeyProcessor(Selector selector, boolean disableOptimisation) {
        if (disableOptimisation) {
            LOG.trace("Selector set optimisation disabled");
        } else {
            ImmediatelyDispatchSelectedKey set = SelectedKeyProcessorFactory.createOptimisedSet(selector);
            if (set != null) {
                return ls -> set.zeroSize();
            }
        }
        return SelectedKeyProcessorFactory::handleKeys;
    }

    private static void handleKeys(Selector selector) throws ClosedSelectorException {
        Set<SelectionKey> keys = selector.selectedKeys();
        for (SelectionKey selectedKey : keys) {
            SelectedKeyProcessorFactory.notifyKeySelected(selectedKey);
        }
        keys.clear();
    }

    private static boolean isSet(int mask, int flag) {
        return (mask & flag) != 0;
    }

    private static void notifyKeySelected(SelectionKey selectedKey) {
        if (selectedKey.isValid()) {
            try {
                int ops = selectedKey.readyOps() & selectedKey.interestOps();
                if (SelectedKeyProcessorFactory.isSet(ops, 16)) {
                    SelectedKeyProcessorFactory.onAcceptable(selectedKey);
                } else {
                    KeyAttachment attachment = (KeyAttachment)selectedKey.attachment();
                    if (SelectedKeyProcessorFactory.isSet(ops, 1)) {
                        SelectedKeyProcessorFactory.onReadable(selectedKey, attachment);
                    }
                    if (SelectedKeyProcessorFactory.isSet(ops, 4)) {
                        SelectedKeyProcessorFactory.onWritable(selectedKey, attachment);
                    }
                }
            }
            catch (CancelledKeyException e) {
                LOG.trace("Cancelled key", e);
            }
        }
    }

    private static void onAcceptable(SelectionKey key) {
        NIOConnector connector = (NIOConnector)key.attachment();
        try {
            ServerSocketChannel serverSocketChannel = (ServerSocketChannel)key.channel();
            SocketChannel socketChannel = serverSocketChannel.accept();
            if (socketChannel == null) {
                return;
            }
            connector.channelSetup(socketChannel);
        }
        catch (ClosedChannelException | NotYetBoundException cce) {
            LOG.warn("IO_NIO_UNABLE_TO_ACCEPT_CONNECTION", connector, cce, cce);
        }
        catch (IOException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("IO_NIO_UNABLE_TO_ACCEPT_CONNECTION", (Object)connector, (Object)e.getMessage());
            }
            LOG.debug("Connector '{}:' - Unable to accept connection", (Object)connector, (Object)e);
        }
    }

    private static void onReadable(SelectionKey key, KeyAttachment attachment) {
        key.interestOps(key.interestOps() & 0xFFFFFFFE);
        attachment.getReadTask().schedule();
    }

    private static void onWritable(SelectionKey key, KeyAttachment attachment) {
        LOG.trace("Notifying key is ready: {}", (Object)key);
        key.interestOps(key.interestOps() & 0xFFFFFFFB);
        attachment.getWriteCallback().notifyReady();
    }

    private static ImmediatelyDispatchSelectedKey createOptimisedSet(Selector selector) {
        try {
            ClassLoader systemClassLoader = AccessController.doPrivileged(ClassLoader::getSystemClassLoader);
            Class<?> selectorImplClass = Class.forName("sun.nio.ch.SelectorImpl", false, systemClassLoader);
            Field selectedKeysField = selectorImplClass.getDeclaredField("selectedKeys");
            Field publicSelectedKeysField = selectorImplClass.getDeclaredField("publicSelectedKeys");
            long selectedKeysFieldOffset = UnsafeAccess.UNSAFE.objectFieldOffset(selectedKeysField);
            long publicSelectedKeysFieldOffset = UnsafeAccess.UNSAFE.objectFieldOffset(publicSelectedKeysField);
            if (selectedKeysFieldOffset != -1L && publicSelectedKeysFieldOffset != -1L) {
                ImmediatelyDispatchSelectedKey keySet = new ImmediatelyDispatchSelectedKey();
                UnsafeAccess.UNSAFE.putObject(selector, selectedKeysFieldOffset, keySet);
                UnsafeAccess.UNSAFE.putObject(selector, publicSelectedKeysFieldOffset, keySet);
                LOG.trace("Applied selector set optimisation to {}", (Object)selector);
                return keySet;
            }
            LOG.warn("IO_NIO_SELECTOR_SET_OPTIMISATION_FAILED", (Object)selector);
        }
        catch (ReflectiveOperationException | SecurityException e) {
            LOG.warn("IO_NIO_SELECTOR_SET_OPTIMISATION_FAILED", (Object)selector, (Object)e);
        }
        return null;
    }

    @NotThreadSafe
    private static final class ImmediatelyDispatchSelectedKey
    extends AbstractSet<SelectionKey> {
        private int size = 0;

        private ImmediatelyDispatchSelectedKey() {
        }

        @Override
        public boolean add(SelectionKey key) {
            SelectedKeyProcessorFactory.notifyKeySelected(key);
            ++this.size;
            return true;
        }

        void zeroSize() {
            this.size = 0;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean remove(Object o) {
            return false;
        }

        @Override
        public boolean contains(Object o) {
            return false;
        }

        @Override
        public Iterator<SelectionKey> iterator() {
            throw new UnsupportedOperationException();
        }
    }
}

