/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.io.nio;

import com.pushtechnology.diffusion.exceptions.DiffusionInterruptedException;
import com.pushtechnology.diffusion.io.nio.NetworkChannel;
import com.pushtechnology.diffusion.logs.i18n.I18nLogger;
import com.pushtechnology.diffusion.threads.MultiplexerOnly;
import com.pushtechnology.diffusion.utils.CharsetUtils;
import com.pushtechnology.diffusion.utils.ConfigurationUtils;
import com.pushtechnology.diffusion.utils.bytebuffer.DirectByteBufferPool;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.EOFException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import net.jcip.annotations.NotThreadSafe;
import org.slf4j.Logger;

@NotThreadSafe
public final class SSLNetworkChannel
extends NetworkChannel {
    private static final String DISABLE_HOST_VERIFICATION_PROPERTY = "diffusion.disable.ssl.host.verification";
    private static final boolean HOST_VERIFICATION_DISABLED = ConfigurationUtils.getBooleanSystemProperty("diffusion.disable.ssl.host.verification");
    private static final Logger LOG = I18nLogger.getLogger(SSLNetworkChannel.class);
    private static final ByteBuffer EMPTY_BYTE_BUFFER = ByteBuffer.allocate(0);
    private final SSLEngine sslEngine;
    private static final ByteBuffer RESERVED = ByteBuffer.allocate(0).asReadOnlyBuffer();
    private static final ByteBuffer NO_INBOUND_BUFFER = ByteBuffer.allocate(0).asReadOnlyBuffer();
    private static final AtomicReferenceFieldUpdater<SSLNetworkChannel, ByteBuffer> INBOUND_BUFFER = AtomicReferenceFieldUpdater.newUpdater(SSLNetworkChannel.class, ByteBuffer.class, "encryptedInboundBuffer");
    private volatile ByteBuffer encryptedInboundBuffer = NO_INBOUND_BUFFER;
    private volatile ByteBuffer remainingBuffer;
    private final boolean thisIsTraceLogging = LOG.isTraceEnabled();
    private final boolean thisIsDebugLogging = LOG.isDebugEnabled();
    private final int outboundPacketSize;
    private final int inboundPacketSize;
    private final int minimumReadBufferSize;

    SSLEngine getSSLEngine() {
        return this.sslEngine;
    }

    public SSLNetworkChannel(NetworkChannel originalChannel, SSLContext sslContext, boolean clientMode, String sniHost, String expectedPeerHost, int inputBufferSize, int outputBufferSize) {
        super(originalChannel);
        this.sslEngine = sslContext.createSSLEngine(expectedPeerHost, 0);
        this.sslEngine.setUseClientMode(clientMode);
        if (sniHost != null) {
            SSLNetworkChannel.enableSNI(sniHost, this.sslEngine);
        }
        if (expectedPeerHost != null && !HOST_VERIFICATION_DISABLED) {
            SSLNetworkChannel.enableHostVerification(this.sslEngine);
        }
        SSLSession session = this.sslEngine.getSession();
        this.minimumReadBufferSize = session.getApplicationBufferSize();
        int packetBufferSize = session.getPacketBufferSize();
        this.outboundPacketSize = Math.max(packetBufferSize, outputBufferSize);
        this.inboundPacketSize = Math.max(packetBufferSize, inputBufferSize);
    }

    private static void enableSNI(String sniHost, SSLEngine sslEngine) {
        try {
            Class<?> clazz = Class.forName("com.pushtechnology.diffusion.io.nio.SNIExtensionEnabler");
            Method enableSNI = clazz.getMethod("enableSNI", SSLEngine.class, String.class);
            enableSNI.invoke(null, sslEngine, sniHost);
        }
        catch (ClassNotFoundException e) {
            LOG.debug("Failed to load SNIExtensionEnabler, does the environment support SNI?", e);
        }
        catch (InvocationTargetException e) {
            LOG.debug("An error occurred while enabling SNI.", e);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new AssertionError("Could not access enableSNI.", e);
        }
    }

    private static void enableHostVerification(SSLEngine sslEngine) {
        try {
            Class<?> clazz = Class.forName("javax.net.ssl.SSLParameters");
            Method setAlgorithm = clazz.getMethod("setEndpointIdentificationAlgorithm", String.class);
            SSLParameters sslParameters = sslEngine.getSSLParameters();
            setAlgorithm.invoke((Object)sslParameters, "HTTPS");
            sslEngine.setSSLParameters(sslParameters);
        }
        catch (ClassNotFoundException | NoSuchMethodException ex) {
            LOG.debug("Failed to enable host verification", ex);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw new AssertionError("Could not enable host verification", ex);
        }
    }

    static String[] parseAndRestrictProperty(String propertyValue, String[] allowedValues) {
        String[] split = propertyValue.split(",", -1);
        HashSet<String> result = new HashSet<String>(split.length);
        for (String c : split) {
            result.add(c.trim());
        }
        result.retainAll(Arrays.asList(allowedValues));
        return result.toArray(new String[0]);
    }

    public void inboundHandshake(ByteBuffer buffer, long writeTimeout) throws IOException {
        this.startHandShake();
        ByteBuffer encrypted = this.directBufferPool().provide(Math.max(this.inboundPacketSize, buffer.remaining()));
        encrypted.put(buffer);
        buffer.clear();
        this.doHandshakeLoop(encrypted, buffer, writeTimeout);
    }

    @Override
    public boolean isSecure() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer plaintext) throws IOException {
        ByteBuffer encrypted = this.reserveInboundBuffer();
        try {
            int read = super.read(encrypted);
            if (read <= 0) {
                int n = read;
                return n;
            }
            encrypted.flip();
            int initialPosition = plaintext.position();
            SSLEngineResult result = this.unwrapAll(encrypted, plaintext);
            int bytesRead = plaintext.position() - initialPosition;
            if (bytesRead == 0 && result.getStatus() == SSLEngineResult.Status.CLOSED) {
                int n = -1;
                return n;
            }
            int n = bytesRead;
            return n;
        }
        finally {
            this.returnInboundBuffer(encrypted);
            if (!this.isOpen()) {
                this.releaseInboundBuffer();
            }
        }
    }

    public void handShake(ByteBuffer plaintext, long writeTimeout) throws IOException {
        this.startHandShake();
        this.doHandshakeLoop(this.directBufferPool().provide(this.inboundPacketSize), plaintext, writeTimeout);
    }

    void startHandShake() throws IOException {
        this.sslEngine.beginHandshake();
    }

    void endHandShake(ByteBuffer encrypted) {
        if (encrypted.position() == 0 || !this.casInboundBuffer(NO_INBOUND_BUFFER, encrypted)) {
            this.directBufferPool().release(encrypted);
        }
    }

    private void doHandshakeLoop(ByteBuffer encrypted, ByteBuffer plaintext, long writeTimeout) throws IOException {
        if (this.thisIsTraceLogging) {
            LOG.trace("'{}:' doHandshake starting", (Object)this);
        }
        this.networkContext().getNetworkStatistics().updateNetworkInbound(plaintext.remaining());
        SSLEngineResult.HandshakeStatus handshakeStatus = this.sslEngine.getHandshakeStatus();
        try {
            block6: while (handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED) {
                if (this.thisIsTraceLogging) {
                    LOG.trace("'{}:' doHandshake loop - status='{}'", (Object)this, (Object)handshakeStatus);
                }
                switch (handshakeStatus) {
                    case NEED_UNWRAP: {
                        handshakeStatus = this.doHandshakeRead(encrypted, plaintext);
                        continue block6;
                    }
                    case NEED_WRAP: {
                        handshakeStatus = this.doHandshakeWrite(writeTimeout);
                        continue block6;
                    }
                }
                throw new SSLException("Invalid Handshaking State: Handshake status: " + String.valueOf((Object)handshakeStatus));
            }
            if (this.thisIsTraceLogging) {
                LOG.trace("'{}:' doHandshake finished '{}'", (Object)this, (Object)encrypted);
            }
            encrypted.flip();
            this.unwrapAll(encrypted, plaintext);
            this.endHandShake(encrypted);
        }
        catch (IOException e) {
            this.directBufferPool().release(encrypted);
            throw e;
        }
    }

    SSLEngineResult.HandshakeStatus doHandshakeRead(ByteBuffer encrypted, ByteBuffer plaintext) throws IOException {
        SSLEngineResult.HandshakeStatus handshakeStatus;
        SSLEngineResult sslResult;
        if (this.thisIsTraceLogging) {
            LOG.trace("'{}:' doHandshakeRead starting", (Object)this);
        }
        block10: while (true) {
            encrypted.flip();
            sslResult = this.unwrap(encrypted, plaintext);
            handshakeStatus = sslResult.getHandshakeStatus();
            switch (sslResult.getStatus()) {
                case OK: {
                    switch (handshakeStatus) {
                        case NEED_TASK: {
                            if (this.thisIsTraceLogging) {
                                LOG.trace("'{}:' execute delegated task '{}'", (Object)this, (Object)encrypted);
                            }
                            this.executeDelegatedTask();
                            continue block10;
                        }
                        case FINISHED: 
                        case NOT_HANDSHAKING: {
                            if (this.thisIsTraceLogging) {
                                LOG.trace("'{}:' doHandshake finished 1 '{}'", (Object)this, (Object)encrypted);
                            }
                            return SSLEngineResult.HandshakeStatus.FINISHED;
                        }
                        case NEED_WRAP: {
                            return SSLEngineResult.HandshakeStatus.NEED_WRAP;
                        }
                    }
                    continue block10;
                }
                case BUFFER_UNDERFLOW: {
                    if (handshakeStatus.equals((Object)SSLEngineResult.HandshakeStatus.NEED_WRAP)) {
                        return handshakeStatus;
                    }
                    this.readHandshakeData(encrypted);
                    continue block10;
                }
                case BUFFER_OVERFLOW: {
                    throw new SSLException("SSL Buffer Overflow");
                }
            }
            break;
        }
        throw new SSLException("SSL Handshake exception: Status: " + String.valueOf((Object)sslResult.getStatus()) + " Handshake status: " + String.valueOf((Object)handshakeStatus));
    }

    private int readHandshakeData(ByteBuffer inputBuffer) throws IOException {
        int result;
        do {
            result = this.getSocketChannel().read(inputBuffer);
            if (this.thisIsTraceLogging) {
                LOG.trace("'{}:' read result='{}'", (Object)this, (Object)result);
            }
            if (result <= 0) continue;
            return result;
        } while (result != -1);
        throw new EOFException("End of stream reading handshake data");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SSLEngineResult.HandshakeStatus doHandshakeWrite(long writeTimeout) throws IOException {
        SSLEngineResult.HandshakeStatus handshakeStatus;
        if (this.thisIsTraceLogging) {
            LOG.trace("'{}:' doHandshakeWrite starting", (Object)this);
        }
        ByteBuffer outputBuffer = this.directBufferPool().provide(this.outboundPacketSize);
        try {
            do {
                SSLEngineResult sslResult = this.wrap(EMPTY_BYTE_BUFFER, outputBuffer);
                handshakeStatus = sslResult.getHandshakeStatus();
                if (sslResult.getStatus() == SSLEngineResult.Status.OK) {
                    if (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                        this.executeDelegatedTask();
                        continue;
                    }
                    this.flush(outputBuffer, writeTimeout);
                    outputBuffer.clear();
                    continue;
                }
                throw new SSLException("Handshaking error: Status: " + String.valueOf((Object)sslResult.getStatus()) + " Handshake status: " + String.valueOf((Object)handshakeStatus));
            } while (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP);
        }
        finally {
            this.directBufferPool().release(outputBuffer);
        }
        return handshakeStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer buffer, long writeTimeout) throws IOException {
        int bytesConsumed = 0;
        while (buffer.hasRemaining()) {
            ByteBuffer outputBuffer = this.directBufferPool().provide(this.outboundPacketSize);
            try {
                SSLEngineResult result = this.wrap(buffer, outputBuffer);
                super.write(outputBuffer, writeTimeout);
                bytesConsumed += result.bytesConsumed();
            }
            finally {
                this.directBufferPool().release(outputBuffer);
            }
        }
        return bytesConsumed;
    }

    @Override
    public boolean nonBlockingWriteImmediate(ByteBuffer buffer, DirectByteBufferPool directBufferPool) throws IOException {
        boolean fullyWritten;
        assert (!buffer.isDirect()) : buffer;
        this.nonBlockingFlush(directBufferPool);
        if (this.remainingBuffer != null) {
            this.remainingBuffer = SSLNetworkChannel.accumulateOverflowBuffer(buffer, this.remainingBuffer);
            return false;
        }
        ByteBuffer outputBuffer = directBufferPool.provide(this.outboundPacketSize);
        try {
            this.wrapAll(buffer, outputBuffer);
        }
        catch (IOException ioe) {
            directBufferPool.release(outputBuffer);
            throw ioe;
        }
        if (buffer.hasRemaining()) {
            this.remainingBuffer = buffer;
        }
        return (fullyWritten = super.nonBlockingWriteImmediate(outputBuffer, directBufferPool)) && !buffer.hasRemaining();
    }

    private static ByteBuffer accumulateOverflowBuffer(ByteBuffer buffer, ByteBuffer overflow) {
        if (overflow.capacity() - overflow.limit() >= buffer.remaining()) {
            overflow.position(overflow.limit());
            overflow.limit(overflow.capacity());
            overflow.put(buffer);
            overflow.flip();
            return overflow;
        }
        ByteBuffer overflowBuffer = ByteBuffer.allocate(overflow.remaining() + buffer.remaining());
        overflowBuffer.put(overflow);
        overflowBuffer.put(buffer);
        overflowBuffer.flip();
        return overflowBuffer;
    }

    @Override
    public boolean nonBlockingFlush(DirectByteBufferPool directPool) throws IOException {
        boolean fullyWritten;
        if (!super.nonBlockingFlush(directPool)) {
            return false;
        }
        ByteBuffer rb = this.remainingBuffer;
        if (rb == null) {
            return true;
        }
        ByteBuffer outputBuffer = directPool.provide(this.outboundPacketSize);
        try {
            this.wrapAll(rb, outputBuffer);
        }
        catch (IOException ioe) {
            directPool.release(outputBuffer);
            throw ioe;
        }
        if (!rb.hasRemaining()) {
            this.remainingBuffer = null;
        }
        return (fullyWritten = super.nonBlockingWriteImmediate(outputBuffer, directPool)) && !rb.hasRemaining();
    }

    private SSLEngineResult unwrapAll(ByteBuffer encrypted, ByteBuffer plaintext) throws SSLException {
        SSLEngineResult result;
        block5: while (true) {
            result = this.unwrap(encrypted, plaintext);
            switch (result.getStatus()) {
                case BUFFER_UNDERFLOW: 
                case CLOSED: {
                    return result;
                }
                case OK: {
                    if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                        this.executeDelegatedTask();
                    }
                    if (encrypted.position() == 0) {
                        return result;
                    }
                    encrypted.flip();
                    continue block5;
                }
                case BUFFER_OVERFLOW: {
                    if (this.thisIsDebugLogging) {
                        LOG.debug("SSL Buffer Full plain={} encrypted={} - try increasing input buffer size", (Object)plaintext, (Object)encrypted);
                    }
                    return result;
                }
            }
            break;
        }
        throw new SSLException("Unwrap error: " + String.valueOf((Object)result.getStatus()));
    }

    @SuppressFBWarnings(value={"DCN_NULLPOINTER_EXCEPTION"})
    private SSLEngineResult unwrap(ByteBuffer encrypted, ByteBuffer plaintext) throws SSLException {
        if (this.thisIsTraceLogging) {
            LOG.trace("'{}:' start unwrap - src: '{}',  dst: '{}'", this, encrypted, plaintext);
        }
        assert (encrypted != RESERVED) : "RESERVED";
        assert (encrypted != NO_INBOUND_BUFFER) : "NO_INBOUND_BUFFER";
        try {
            SSLEngineResult result = this.sslEngine.unwrap(encrypted, plaintext);
            encrypted.compact();
            if (this.thisIsTraceLogging && LOG.isTraceEnabled()) {
                int bytesProduced = result.bytesProduced();
                LOG.trace("'{}:' after unwrap - src: '{}' dst: '{}' consumed: '{}' produced: '{}' status: '{}' handshakeStatus: '{}'", new Object[]{this, encrypted, plaintext, result.bytesConsumed(), result.bytesProduced(), result.getStatus(), result.getHandshakeStatus()});
                if (bytesProduced > 0) {
                    plaintext.position(plaintext.position() - bytesProduced);
                    byte[] producedBytes = new byte[bytesProduced];
                    plaintext.get(producedBytes);
                    LOG.trace("{}: '{}'", (Object)this, (Object)CharsetUtils.bytesUTF8ToString(producedBytes));
                }
            }
            return result;
        }
        catch (NullPointerException npe) {
            throw new SSLException(npe);
        }
    }

    private SSLEngineResult wrap(ByteBuffer byteBuffer, ByteBuffer outputBuffer) throws SSLException {
        SSLEngineResult result = this.sslEngine.wrap(byteBuffer, outputBuffer);
        if (result.getStatus() != SSLEngineResult.Status.OK) {
            throw new SSLException("SSL Wrap result [" + String.valueOf(result) + "]");
        }
        outputBuffer.flip();
        return result;
    }

    private SSLEngineResult doWrap(ByteBuffer byteBuffer, ByteBuffer outputBuffer) throws SSLException {
        SSLEngineResult result = this.sslEngine.wrap(byteBuffer, outputBuffer);
        if (this.thisIsTraceLogging && LOG.isTraceEnabled()) {
            LOG.trace("'{}:' after wrap - src: '{}' dst: '{}' consumed: '{}' produced: '{}' status: '{}' handshakeStatus: '{}'", new Object[]{this, byteBuffer, outputBuffer, result.bytesConsumed(), result.bytesProduced(), result.getStatus(), result.getHandshakeStatus()});
        }
        return result;
    }

    private void wrapAll(ByteBuffer byteBuffer, ByteBuffer outputBuffer) throws SSLException {
        SSLEngineResult result = this.doWrap(byteBuffer, outputBuffer);
        while (byteBuffer.hasRemaining() && result.getStatus() == SSLEngineResult.Status.OK) {
            result = this.doWrap(byteBuffer, outputBuffer);
        }
        if (byteBuffer.hasRemaining() && result.getStatus() == SSLEngineResult.Status.CLOSED) {
            throw new SSLException("SSLEngine was closed while trying to flush data");
        }
        outputBuffer.flip();
    }

    private void executeDelegatedTask() {
        Runnable runnable;
        while ((runnable = this.sslEngine.getDelegatedTask()) != null) {
            runnable.run();
        }
        return;
    }

    @Override
    protected boolean hasRemainingOutputData() {
        return super.hasRemainingOutputData() || this.remainingBuffer != null;
    }

    @Override
    protected void doClose() {
        try {
            if (this.hasRemainingOutputData()) {
                LOG.warn("IO_NIO_SSL_CLOSE_ERROR", (Object)this);
            }
            SSLEngine engine = this.sslEngine;
            engine.closeOutbound();
            engine.closeInbound();
        }
        catch (SSLException ex) {
            LOG.debug("Error shutting down SSL engine {}", (Object)this, (Object)ex);
        }
        finally {
            super.doClose();
            this.releaseInboundBuffer();
        }
    }

    @Override
    @MultiplexerOnly
    protected boolean doCloseOutbound(DirectByteBufferPool directByteBufferPool) throws IOException {
        try {
            if (this.hasRemainingOutputData() && !this.nonBlockingFlush(directByteBufferPool)) {
                return false;
            }
            SSLEngine engine = this.sslEngine;
            engine.closeOutbound();
            if (!engine.isOutboundDone() && this.isOpen()) {
                LOG.trace("Writing close handshake {}", (Object)this);
                if (!this.nonBlockingWriteImmediate(EMPTY_BYTE_BUFFER, directByteBufferPool)) {
                    LOG.trace("Could not fully flush close handshake {}", (Object)this);
                    return false;
                }
            }
            try {
                super.doCloseOutbound(directByteBufferPool);
            }
            catch (IOException ignore) {
                DiffusionInterruptedException.ioException(ignore);
            }
            LOG.trace("SSL outbound connection closed normally {}", (Object)this);
        }
        catch (IOException ioe) {
            super.doCloseOutbound(directByteBufferPool);
            throw ioe;
        }
        return true;
    }

    @Override
    @MultiplexerOnly
    protected void doCloseInbound() {
        try {
            this.sslEngine.closeInbound();
            LOG.trace("SSL inbound connection closed normally {}", (Object)this);
        }
        catch (SSLException ssle) {
            LOG.trace("SSL inbound connection closed exceptionally {}", (Object)this, (Object)ssle);
        }
        super.doCloseInbound();
        this.releaseInboundBuffer();
    }

    @Override
    @MultiplexerOnly
    public ByteBuffer bufferForWriting(DirectByteBufferPool directPool, int minimumCapacity) {
        return ByteBuffer.allocate(minimumCapacity);
    }

    @Override
    public ByteBuffer bufferForReading(int minimumCapacity) {
        return ByteBuffer.allocate(Math.max(this.minimumReadBufferSize, minimumCapacity));
    }

    @Override
    public int minimumReadBufferSize() {
        return this.minimumReadBufferSize;
    }

    private void returnInboundBuffer(ByteBuffer encrypted) {
        if (encrypted.position() > 0) {
            INBOUND_BUFFER.lazySet(this, encrypted);
        } else {
            this.directBufferPool().release(encrypted);
            INBOUND_BUFFER.lazySet(this, NO_INBOUND_BUFFER);
        }
    }

    private ByteBuffer reserveInboundBuffer() throws ClosedChannelException {
        ByteBuffer eib;
        do {
            if ((eib = this.encryptedInboundBuffer) != null) continue;
            throw new ClosedChannelException();
        } while (eib == RESERVED || !this.casInboundBuffer(eib, RESERVED));
        if (eib == NO_INBOUND_BUFFER) {
            return this.directBufferPool().provide(this.inboundPacketSize);
        }
        return eib;
    }

    private void releaseInboundBuffer() {
        ByteBuffer eib;
        do {
            if ((eib = this.encryptedInboundBuffer) != RESERVED) continue;
            return;
        } while (!this.casInboundBuffer(eib, null));
        if (eib != null) {
            this.directBufferPool().release(eib);
        }
    }

    private boolean casInboundBuffer(ByteBuffer expectedBuffer, ByteBuffer newBuffer) {
        return INBOUND_BUFFER.compareAndSet(this, expectedBuffer, newBuffer);
    }
}

