/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.io.nio;

import com.pushtechnology.diffusion.exceptions.DiffusionInterruptedException;
import com.pushtechnology.diffusion.io.nio.MultiplexerExecutor;
import com.pushtechnology.diffusion.io.nio.NetworkContext;
import com.pushtechnology.diffusion.io.nio.ReadableNetworkChannel;
import com.pushtechnology.diffusion.io.nio.ThreadTemporarySelector;
import com.pushtechnology.diffusion.io.nio.WritableNetworkChannel;
import com.pushtechnology.diffusion.threads.MultiplexerOnly;
import com.pushtechnology.diffusion.time.SystemTime;
import com.pushtechnology.diffusion.utils.ConfigurationUtils;
import com.pushtechnology.diffusion.utils.bytebuffer.DirectByteBufferPool;
import com.pushtechnology.diffusion.utils.io.IOUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import net.jcip.annotations.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class NetworkChannel
implements ReadableNetworkChannel,
WritableNetworkChannel {
    private static final Logger LOG = LoggerFactory.getLogger(NetworkChannel.class);
    private static final int MAX_CHUNK_SIZE = 131072;
    private static final AtomicReferenceFieldUpdater<NetworkChannel, ByteBuffer> REMAINING_BUFFER = AtomicReferenceFieldUpdater.newUpdater(NetworkChannel.class, ByteBuffer.class, "remainingBuffer");
    private static final CompletableFuture<Integer> COMPLETED_FUTURE_0 = CompletableFuture.completedFuture(0);
    private final InetSocketAddress proxiedRemoteAddress;
    private final SocketChannel socketChannel;
    private static final String SERVER_CLOSE_GRACE_PERIOD_PROPERTY = "diffusion.client.close.timeout2";
    private static int serverCloseGracePeriod = ConfigurationUtils.getIntegerSystemProperty("diffusion.client.close.timeout2", 1000);
    private volatile ByteBuffer remainingBuffer;
    private final NetworkContext networkContext;
    private volatile boolean closed = true;
    private volatile boolean inputClosed = true;
    private static final AtomicIntegerFieldUpdater<NetworkChannel> OUTBOUND_STATE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(NetworkChannel.class, "outboundClosed");
    private volatile int outboundClosed = 1;

    static void setServerCloseGracePeriod(int gracePeriodMillis) {
        serverCloseGracePeriod = gracePeriodMillis;
    }

    public NetworkChannel(SocketChannel socketChannel, NetworkContext networkContext) {
        this(socketChannel, networkContext, null);
    }

    private NetworkChannel(SocketChannel socketChannel, NetworkContext networkContext, InetSocketAddress proxiedRemoteAddress) {
        this.socketChannel = socketChannel;
        this.networkContext = networkContext;
        this.proxiedRemoteAddress = proxiedRemoteAddress;
        this.closed = !socketChannel.isOpen();
        OUTBOUND_STATE_UPDATER.set(this, this.closed || socketChannel.socket().isOutputShutdown() ? 1 : 0);
        this.inputClosed = this.closed || socketChannel.socket().isInputShutdown();
    }

    protected NetworkChannel(NetworkChannel originalChannel) {
        this(originalChannel.socketChannel, originalChannel.networkContext, originalChannel.proxiedRemoteAddress);
    }

    public final SocketChannel getSocketChannel() {
        return this.socketChannel;
    }

    protected final DirectByteBufferPool directBufferPool() {
        return this.networkContext.getBufferPool();
    }

    public final NetworkContext networkContext() {
        return this.networkContext;
    }

    @Override
    public int write(ByteBuffer buffer, long writeTimeout) throws IOException {
        assert (!this.hasRemainingOutputData()) : "write() called in conjunction with non-blocking I/O";
        int bytesToWrite = buffer.remaining();
        this.writeBuffer(buffer);
        if (buffer.hasRemaining()) {
            this.flushBuffer(buffer, writeTimeout);
        }
        return bytesToWrite;
    }

    private int writeBuffer(ByteBuffer buffer) throws IOException {
        int wanted = buffer.remaining();
        int bytes = this.socketChannel.write(buffer);
        if (bytes < wanted) {
            LOG.trace("{}: Tried to write {} bytes, but only managed {}", this, wanted, bytes);
        }
        this.networkContext.getNetworkStatistics().updateNetworkOutbound(bytes);
        return bytes;
    }

    @Override
    @MultiplexerOnly
    public CompletableFuture<Integer> nonBlockingWrite(ByteBuffer buffer, DirectByteBufferPool directPool, MultiplexerExecutor multiplexerExecutor) {
        try {
            if (this.nonBlockingWriteImmediate(buffer, directPool)) {
                return COMPLETED_FUTURE_0;
            }
            return this.flushWhenWriteReady(multiplexerExecutor);
        }
        catch (IOException e) {
            CompletableFuture<Integer> result = new CompletableFuture<Integer>();
            result.completeExceptionally(e);
            return result;
        }
    }

    @Override
    @MultiplexerOnly
    public boolean nonBlockingWriteImmediate(ByteBuffer buffer, DirectByteBufferPool directPool) throws IOException {
        if (this.remainingBuffer != null) {
            throw new IllegalStateException("previous write has not completed; remaining buffer=" + String.valueOf(this.remainingBuffer));
        }
        return this.nonBlockingWrite(buffer, directPool);
    }

    private boolean nonBlockingWrite(ByteBuffer buffer, DirectByteBufferPool directPool) throws IOException {
        int bytesWritten;
        try {
            bytesWritten = this.writeBuffer(buffer);
        }
        catch (IOException ioe) {
            directPool.release(buffer);
            throw ioe;
        }
        if (buffer.hasRemaining()) {
            LOG.trace("Partial write of '{}' bytes, remaining buffer '{}'", (Object)bytesWritten, (Object)buffer);
            this.setRemainingBuffer(buffer, directPool);
            return false;
        }
        directPool.release(buffer);
        return true;
    }

    @Override
    @MultiplexerOnly
    public final CompletableFuture<Integer> flushWhenWriteReady(final MultiplexerExecutor multiplexerExecutor) {
        final CompletableFuture<Integer> result = new CompletableFuture<Integer>();
        this.onReadyToWrite(multiplexerExecutor, new MultiplexerExecutor.Task(){
            private int flushes = 1;

            @Override
            public void execute(DirectByteBufferPool buffers) {
                try {
                    if (NetworkChannel.this.nonBlockingFlush(buffers)) {
                        result.complete(this.flushes);
                    } else {
                        ++this.flushes;
                        NetworkChannel.this.onReadyToWrite(multiplexerExecutor, this);
                    }
                }
                catch (IOException e) {
                    result.completeExceptionally(e);
                }
            }
        });
        return result;
    }

    @MultiplexerOnly
    final boolean markOutboundClosed() {
        return OUTBOUND_STATE_UPDATER.compareAndSet(this, 0, 1);
    }

    public final boolean isInputShutdown() {
        return this.inputClosed;
    }

    public boolean isOutputShutdown() {
        return this.outboundClosed > 0;
    }

    @MultiplexerOnly
    private CompletableFuture<Integer> doNonBlockingCloseOutbound(DirectByteBufferPool directPool, final MultiplexerExecutor multiplexerExecutor) {
        final long startTime = SystemTime.currentTimeMillis();
        LOG.debug("nonBlockingCloseOutbound() {}", (Object)this);
        try {
            if (this.doCloseOutbound(directPool)) {
                LOG.debug("nonBlockingCloseOutbound() complete {}", (Object)this);
                return COMPLETED_FUTURE_0;
            }
            LOG.trace("nonBlockingCloseOutbound() flushing pending data {}", (Object)this);
            final CompletableFuture<Integer> result = new CompletableFuture<Integer>();
            this.onReadyToWrite(multiplexerExecutor, new MultiplexerExecutor.Task(){
                private int retries = 0;

                @Override
                public void execute(DirectByteBufferPool buffers) {
                    try {
                        if (NetworkChannel.this.doCloseOutbound(buffers)) {
                            LOG.debug("nonBlockingCloseOutbound() complete {}", (Object)this);
                            result.complete(this.retries);
                        } else {
                            ++this.retries;
                            if (this.retries > 0 && SystemTime.currentTimeMillis() - startTime > (long)serverCloseGracePeriod) {
                                throw new IOException("Timeout in non-blocking close of channel");
                            }
                            NetworkChannel.this.onReadyToWrite(multiplexerExecutor, this);
                        }
                    }
                    catch (IOException e) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Error in nonBlockingCloseOutbound() after {} tries in {}ms {}", this.retries, SystemTime.currentTimeMillis() - startTime, NetworkChannel.this, e);
                        }
                        NetworkChannel.this.doCloseSelector(buffers);
                        result.completeExceptionally(e);
                    }
                }
            });
            return result;
        }
        catch (IOException ioe) {
            LOG.debug("Error in nonBlockingCloseOutbound(), closing channel {}", (Object)this, (Object)ioe);
            this.doCloseSelector(directPool);
            CompletableFuture<Integer> result = new CompletableFuture<Integer>();
            result.completeExceptionally(ioe);
            return result;
        }
    }

    @Override
    @MultiplexerOnly
    public CompletableFuture<Integer> nonBlockingCloseOutbound(DirectByteBufferPool directPool, MultiplexerExecutor multiplexerExecutor) {
        if (this.markOutboundClosed()) {
            return this.doNonBlockingCloseOutbound(directPool, multiplexerExecutor);
        }
        LOG.debug("nonBlockingCloseOutbound() complete, outbound already closed {}", (Object)this);
        return COMPLETED_FUTURE_0;
    }

    @Override
    @MultiplexerOnly
    public final void nonBlockingCloseInbound(MultiplexerExecutor multiplexerExecutor, Runnable onComplete) {
        this.doCloseInbound();
        LOG.debug("nonBlockingCloseInbound() - closing outbound side {}", (Object)this);
        DirectByteBufferPool directPool = this.directBufferPool();
        this.nonBlockingCloseOutbound(directPool, multiplexerExecutor).whenComplete((result, ex) -> {
            this.doCloseSelector(directPool);
            onComplete.run();
            LOG.debug("nonBlockingCloseInbound() - complete {}", (Object)this, ex);
        });
    }

    @MultiplexerOnly
    private void onReadyToWrite(MultiplexerExecutor executor, MultiplexerExecutor.Task task) {
        this.networkContext.getSelector().registerForWrite(this.socketChannel, () -> executor.executeInMultiplexer(task));
    }

    @Override
    @MultiplexerOnly
    public boolean nonBlockingFlush(DirectByteBufferPool directPool) throws IOException {
        ByteBuffer ob;
        if (this.isOutputShutdown()) {
            throw new ClosedChannelException();
        }
        do {
            if ((ob = this.remainingBuffer) != null) continue;
            return true;
        } while (!this.casRemainingBuffer(ob, null));
        return this.nonBlockingWrite(ob, directPool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void flushBuffer(ByteBuffer buffer, long writeTimeout) throws IOException {
        key = null;
        writeSelector = null;
        attempts = 0;
        maxAttempts = 3;
        attemptTimeout = writeTimeout / 3L;
        while (true) {
            block10: {
                if (!buffer.hasRemaining()) break;
                if (buffer.remaining() > 131072) {
                    originalLimit = buffer.limit();
                    chunkSizeLimit = buffer.position() + 131072;
                    buffer.limit(chunkSizeLimit);
                    bytesWritten = this.writeBuffer(buffer);
                    buffer.limit(originalLimit);
                } else {
                    bytesWritten = this.writeBuffer(buffer);
                }
                if (bytesWritten <= 0) ** GOTO lbl30
                if (buffer.hasRemaining()) break block10;
                if (key != null) {
                    key.cancel();
                }
                if (writeSelector == null) return;
                ThreadTemporarySelector.returnSelector(writeSelector);
                return;
            }
            attempts = 0;
            continue;
lbl30:
            // 1 sources

            if (writeSelector == null) {
                writeSelector = ThreadTemporarySelector.getSelector();
            }
            key = this.socketChannel.register(writeSelector, 4);
            keysReady = writeSelector.select(attemptTimeout);
            if (keysReady != 0) continue;
            NetworkChannel.LOG.trace("{}: blocking select time out, attempt={}", (Object)this, (Object)(++attempts));
            if (attempts > 3) throw new IOException("Write timeout after " + writeTimeout + "ms");
            continue;
            break;
        }
        if (key != null) {
            key.cancel();
        }
        if (writeSelector == null) return;
        ThreadTemporarySelector.returnSelector(writeSelector);
        return;
        catch (Throwable var13_11) {
            if (key != null) {
                key.cancel();
            }
            if (writeSelector == null) throw var13_11;
            ThreadTemporarySelector.returnSelector(writeSelector);
            throw var13_11;
        }
    }

    protected final void flush(ByteBuffer buffer, long writeTimeout) throws IOException {
        if (!this.socketChannel.isBlocking()) {
            this.flushBuffer(buffer, writeTimeout);
        } else {
            while (buffer.hasRemaining()) {
                this.writeBuffer(buffer);
            }
        }
    }

    @Override
    public int read(ByteBuffer buffer) throws IOException {
        try {
            int n = this.socketChannel.read(buffer);
            if (n > 0) {
                this.networkContext.getNetworkStatistics().updateNetworkInbound(n);
            }
            return n;
        }
        catch (ClosedChannelException ex) {
            return -1;
        }
    }

    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public void close() {
        this.closed = true;
        this.inputClosed = true;
        this.markOutboundClosed();
        this.networkContext.getSelector().request(s -> {
            if (LOG.isTraceEnabled()) {
                LOG.trace("doCloseSelector(): {} {}", (Object)this.hexHashCode(), (Object)this.socketChannel);
            }
            this.doClose();
        });
    }

    @MultiplexerOnly
    private boolean doCloseSelector(DirectByteBufferPool directByteBufferPool) {
        this.closed = true;
        this.inputClosed = true;
        this.markOutboundClosed();
        this.networkContext.getSelector().request(s -> {
            try {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("doCloseSelector(): {} {}", (Object)this.hexHashCode(), (Object)this.socketChannel);
                }
                this.socketChannel.close();
            }
            catch (IOException ignore) {
                DiffusionInterruptedException.ioException(ignore);
            }
        });
        this.releaseRemainingBuffer(directByteBufferPool);
        return true;
    }

    @MultiplexerOnly
    protected void doCloseInbound() {
        this.inputClosed = true;
        this.networkContext.getSelector().request(s -> {
            try {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("doCloseInbound(): {} {}", (Object)this.hexHashCode(), (Object)this.socketChannel);
                }
                this.socketChannel.socket().shutdownInput();
            }
            catch (IOException ignore) {
                IOUtils.closeQuietly(this.socketChannel);
                DiffusionInterruptedException.ioException(ignore);
            }
        });
    }

    @MultiplexerOnly
    protected boolean doCloseOutbound(DirectByteBufferPool directByteBufferPool) throws IOException {
        OUTBOUND_STATE_UPDATER.set(this, 1);
        this.networkContext.getSelector().request(s -> {
            try {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("doCloseOutbound(): {} {}", (Object)this.hexHashCode(), (Object)this.socketChannel);
                }
                this.socketChannel.socket().shutdownOutput();
            }
            catch (IOException ignore) {
                IOUtils.closeQuietly(this.socketChannel);
                DiffusionInterruptedException.ioException(ignore);
            }
        });
        this.releaseRemainingBuffer(directByteBufferPool);
        return true;
    }

    protected void doClose() {
        IOUtils.closeQuietly(this.socketChannel);
        this.releaseRemainingBuffer(this.directBufferPool());
    }

    private void releaseRemainingBuffer(DirectByteBufferPool pool) {
        ByteBuffer ob;
        while (!this.casRemainingBuffer(ob = this.remainingBuffer, null)) {
        }
        if (ob != null) {
            pool.release(ob);
        }
    }

    @Override
    public boolean isSecure() {
        return false;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append(this.getClass().getSimpleName()).append('@').append(this.hexHashCode()).append('[').append(this.socketChannel.isConnected() ? "connected" : "disconnected").append(" local=").append(this.getLocalAddress());
        InetSocketAddress directRemoteAddress = this.getDirectRemoteAddress();
        if (this.proxiedRemoteAddress != null) {
            sb.append(" remote=").append(this.proxiedRemoteAddress).append(" proxied via ").append(directRemoteAddress);
        } else {
            sb.append(" remote=").append(directRemoteAddress);
        }
        sb.append(']');
        return sb.toString();
    }

    private String hexHashCode() {
        return Integer.toHexString(this.socketChannel.hashCode());
    }

    public final NetworkChannel getProxiedChannel(InetSocketAddress sourceAddress) {
        return new NetworkChannel(this.socketChannel, this.networkContext, sourceAddress);
    }

    @Override
    public final void registerForRead() {
        this.networkContext.getSelector().registerForRead(this.socketChannel);
    }

    public void cancelRegistration() {
        this.networkContext.getSelector().cancel(this.socketChannel);
    }

    @Override
    @MultiplexerOnly
    public ByteBuffer bufferForWriting(DirectByteBufferPool directPool, int minimumCapacity) {
        return directPool.provide(minimumCapacity);
    }

    @Override
    public ByteBuffer bufferForReading(int minimumCapacity) {
        return this.directBufferPool().provide(minimumCapacity);
    }

    private boolean casRemainingBuffer(ByteBuffer expectedBuffer, ByteBuffer newBuffer) {
        return REMAINING_BUFFER.compareAndSet(this, expectedBuffer, newBuffer);
    }

    @MultiplexerOnly
    private void setRemainingBuffer(ByteBuffer newBuffer, DirectByteBufferPool directPool) {
        REMAINING_BUFFER.lazySet(this, newBuffer);
        if (!this.isOpen()) {
            this.releaseRemainingBuffer(directPool);
        }
    }

    protected boolean hasRemainingOutputData() {
        return this.remainingBuffer != null;
    }

    @Override
    public int minimumReadBufferSize() {
        return 0;
    }

    public final InetSocketAddress getLocalAddress() {
        int localPort = this.socketChannel.socket().getLocalPort();
        if (localPort == -1) {
            return null;
        }
        return new InetSocketAddress(this.socketChannel.socket().getLocalAddress(), localPort);
    }

    @Override
    public final InetSocketAddress getRemoteAddress() {
        if (this.proxiedRemoteAddress != null) {
            return this.proxiedRemoteAddress;
        }
        return this.getDirectRemoteAddress();
    }

    private InetSocketAddress getDirectRemoteAddress() {
        InetAddress remoteAddress = this.socketChannel.socket().getInetAddress();
        if (remoteAddress == null) {
            return null;
        }
        return new InetSocketAddress(remoteAddress, this.socketChannel.socket().getPort());
    }
}

