/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.io.client;

import com.pushtechnology.diffusion.comms.connection.NetworkContextPool;
import com.pushtechnology.diffusion.io.nio.NetworkContext;
import com.pushtechnology.diffusion.io.nio.NetworkStatisticsCollector;
import com.pushtechnology.diffusion.io.nio.UnifiedSelector;
import com.pushtechnology.diffusion.io.selector.UnifiedSelectorFactory;
import com.pushtechnology.diffusion.utils.ConfigurationUtils;
import com.pushtechnology.diffusion.utils.bytebuffer.DirectByteBufferPool;
import com.pushtechnology.repackaged.picocontainer.Disposable;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.Immutable;

@Immutable
public final class ClientNetworkContextPool
implements NetworkContextPool,
Disposable {
    private static final NetworkStatisticsCollector NULL_NETWORK_STATISTICS = new NetworkStatisticsCollector(){

        @Override
        public void updateNetworkInbound(int bytesReceived) {
        }

        @Override
        public void updateNetworkOutbound(int bytesSent) {
        }
    };
    private final NetworkContext[] selectors;
    private final AtomicInteger selectorIndex = new AtomicInteger();

    public ClientNetworkContextPool(UnifiedSelectorFactory selectorFactory, DirectByteBufferPool bufferPool) {
        int size = ConfigurationUtils.getIntegerSystemProperty("diffusion.outbound.selectors.count", 1);
        this.selectors = new NetworkContext[size];
        for (int i = 0; i < size; ++i) {
            String name = "ClientSelector Thread_" + i;
            UnifiedSelector unifiedSelector = selectorFactory.createUnifiedSelector(name);
            unifiedSelector.start();
            this.selectors[i] = new NetworkContext(unifiedSelector, bufferPool, NULL_NETWORK_STATISTICS);
        }
    }

    @Override
    public NetworkContext next() {
        return this.selectors[this.selectorIndex.incrementAndGet() % this.selectors.length];
    }

    @Override
    public void dispose() {
        for (NetworkContext context : this.selectors) {
            ((UnifiedSelector)context.getSelector()).stop(20000L);
        }
    }
}

