/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.io.bytes;

import com.pushtechnology.diffusion.io.bytes.AbstractIBytes;
import com.pushtechnology.diffusion.io.bytes.ArrayIBytes;
import com.pushtechnology.diffusion.io.bytes.ArrayUtilities;
import com.pushtechnology.diffusion.io.bytes.IBytes;
import com.pushtechnology.diffusion.io.bytes.IBytesInputStream;
import com.pushtechnology.diffusion.utils.string.StringUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import net.jcip.annotations.NotThreadSafe;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public final class ByteBufferIBytes
extends AbstractIBytes {
    private final ByteBuffer source;
    private final int start;
    private final int end;

    public static IBytes wrapBuffer(ByteBuffer source) {
        int position = source.position();
        int limit = source.limit();
        IBytes result = source.hasArray() ? ArrayIBytes.toArrayIBytes(source.array(), source.arrayOffset() + position, limit - position) : new ByteBufferIBytes(source, position, limit);
        source.position(limit);
        return result;
    }

    private ByteBufferIBytes(ByteBuffer source, int start, int end) {
        this.source = source;
        this.start = start;
        this.end = end;
    }

    @Override
    public int length() {
        return this.end - this.start;
    }

    @Override
    public IBytesInputStream asInputStream() {
        return new ByteInputStreamImpl();
    }

    @Override
    public void copyTo(ByteBuffer buffer) {
        ByteBufferIBytes.slice(this.source, this.start, this.end, buffer::put);
    }

    @Override
    public void copyTo(OutputStream stream) throws IOException {
        for (int i = this.start; i < this.end; ++i) {
            stream.write(this.source.get(i));
        }
    }

    @Override
    public byte[] toByteArray() {
        byte[] data = new byte[this.end - this.start];
        ByteBufferIBytes.slice(this.source, this.start, this.end, bb -> bb.get(data));
        return data;
    }

    @Override
    public void appendHex(StringBuilder sb, int limit) {
        StringUtils.appendHex(sb, this.source, this.start, Math.min(this.start + limit, this.end));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void slice(ByteBuffer bb, int position, int limit, Consumer<ByteBuffer> fn) {
        int oldPosition = bb.position();
        int oldLimit = bb.limit();
        bb.limit(limit).position(position);
        try {
            fn.accept(bb);
        }
        finally {
            bb.limit(oldLimit).position(oldPosition);
        }
    }

    @NotThreadSafe
    private final class ByteInputStreamImpl
    extends IBytesInputStream {
        private int position;
        private int mark;

        ByteInputStreamImpl() {
            this.position = ByteBufferIBytes.this.start;
        }

        @Override
        public IBytes toBytes(int length) {
            int e = this.position + Math.min(length, ByteBufferIBytes.this.end - this.position);
            if (this.position >= e) {
                return IBytes.EMPTY_BYTES;
            }
            if (this.position == 0 && e == ByteBufferIBytes.this.end) {
                return ByteBufferIBytes.this;
            }
            return new ByteBufferIBytes(ByteBufferIBytes.this.source, this.position, e);
        }

        @Override
        public int read(ByteBuffer buffer, int l) {
            int p = this.position;
            int remaining = ByteBufferIBytes.this.end - p;
            if (remaining <= 0) {
                return 0;
            }
            int n = Math.min(l, remaining);
            int e = p + n;
            ByteBufferIBytes.slice(ByteBufferIBytes.this.source, p, e, buffer::put);
            this.position = e;
            return n;
        }

        @Override
        public int read() {
            int p = this.position;
            if (p >= ByteBufferIBytes.this.end) {
                return -1;
            }
            this.position = p + 1;
            return ByteBufferIBytes.this.source.get(p) & 0xFF;
        }

        @Override
        public int read(byte[] b, int o, int l) {
            ArrayUtilities.checkBounds(b, o, l);
            int p = this.position;
            int remaining = ByteBufferIBytes.this.end - p;
            if (remaining <= 0) {
                return -1;
            }
            int n = Math.min(l, remaining);
            if (n > 0) {
                ByteBufferIBytes.slice(ByteBufferIBytes.this.source, p, p + n, bb -> bb.get(b, o, n));
                this.position = p + n;
            }
            return n;
        }

        @Override
        public long skip(long n) {
            int p = this.position;
            int n2 = (int)Math.min(n, (long)(ByteBufferIBytes.this.end - p));
            this.position = p + n2;
            return n2;
        }

        @Override
        public int available() {
            return ByteBufferIBytes.this.end - this.position;
        }

        @Override
        public void mark(int readAheadLimit) {
            this.mark = this.position;
        }

        @Override
        public void reset() {
            this.position = this.mark;
        }

        @Override
        public Integer recordMark() {
            return this.position;
        }

        @Override
        public void resetToMark(Object m) {
            this.position = (Integer)m;
        }
    }
}

