/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.io.bytes;

import com.pushtechnology.diffusion.io.bytes.AbstractIBytes;
import com.pushtechnology.diffusion.io.bytes.ArrayIBytes;
import com.pushtechnology.diffusion.io.bytes.ArrayUtilities;
import com.pushtechnology.diffusion.io.bytes.HasArray;
import com.pushtechnology.diffusion.io.bytes.IBytes;
import com.pushtechnology.diffusion.io.bytes.IBytesInputStream;
import com.pushtechnology.diffusion.utils.string.StringUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import net.jcip.annotations.NotThreadSafe;

abstract class AbstractArrayIBytes
extends AbstractIBytes
implements ArrayIBytes {
    private final byte[] bytes;

    AbstractArrayIBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    @Override
    public final byte[] bytes() {
        return this.bytes;
    }

    @Override
    public final void copyTo(ByteBuffer buffer) {
        buffer.put(this.bytes, this.offset(), this.length());
    }

    @Override
    public final void copyTo(OutputStream stream) throws IOException {
        stream.write(this.bytes, this.offset(), this.length());
    }

    @Override
    public final byte[] toByteArray() {
        int offset = this.offset();
        return Arrays.copyOfRange(this.bytes, offset, offset + this.length());
    }

    @Override
    public final void appendHex(StringBuilder sb, int limit) {
        int offset = this.offset();
        StringUtils.appendHex(sb, this.bytes, offset, Math.min(this.length(), limit));
    }

    @Override
    public final int hashCode() {
        int result = 0;
        int offset = this.offset();
        int length = this.length();
        for (int i = 0; i < length; ++i) {
            result = 31 * result + this.bytes[offset + i];
        }
        return result;
    }

    @Override
    public final boolean equalBytes(IBytes o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HasArray)) {
            return super.equalBytes(o);
        }
        HasArray other = (HasArray)((Object)o);
        return this.equalBytes(other.bytes(), other.offset(), other.length());
    }

    @Override
    public final boolean equalBytes(byte[] otherBytes, int otherOffset, int otherLength) {
        if (this.length() != otherLength) {
            return false;
        }
        int offset = this.offset();
        if (this.bytes == otherBytes && offset == otherOffset) {
            return true;
        }
        for (int i = 0; i < otherLength; ++i) {
            if (this.bytes[offset + i] == otherBytes[otherOffset + i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(IBytes subValue, int start) {
        int offset = this.offset();
        if (subValue instanceof HasArray) {
            HasArray other = (HasArray)((Object)subValue);
            return ArrayUtilities.arrayStartsWith(this.bytes, offset + start, this.length() - start, other.bytes(), other.offset(), other.length());
        }
        if (start + subValue.length() > this.length()) {
            return false;
        }
        IBytesInputStream subValueStream = subValue.asInputStream();
        for (int i = 0; i < subValue.length(); ++i) {
            if (subValueStream.read() == (this.bytes[i + offset + start] & 0xFF)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final IBytesInputStream asInputStream() {
        return new IBytesInputStreamImpl();
    }

    @Override
    public boolean sharesBytesWith(IBytes other) {
        if (!(other instanceof HasArray)) {
            return false;
        }
        return this.bytes == ((HasArray)((Object)other)).bytes();
    }

    @NotThreadSafe
    private final class IBytesInputStreamImpl
    extends IBytesInputStream
    implements HasArray {
        private int position;
        private int mark;

        private IBytesInputStreamImpl() {
        }

        @Override
        public IBytes toBytes(int l) {
            int remaining = Math.min(this.available(), l);
            if (remaining == 0) {
                return IBytes.EMPTY_BYTES;
            }
            if (remaining == this.length()) {
                return AbstractArrayIBytes.this;
            }
            return ArrayIBytes.toArrayIBytes(this.bytes(), this.offset(), remaining);
        }

        @Override
        public int read(ByteBuffer buffer, int l) {
            int remaining = this.available();
            if (remaining == 0) {
                return 0;
            }
            int n = Math.min(l, remaining);
            buffer.put(this.bytes(), this.offset(), n);
            this.position += n;
            return n;
        }

        @Override
        public int read() {
            if (this.available() == 0) {
                return -1;
            }
            int offset = this.offset();
            ++this.position;
            return this.bytes()[offset] & 0xFF;
        }

        @Override
        public int read(byte[] b, int o, int l) {
            ArrayUtilities.checkBounds(b, o, l);
            int remaining = this.available();
            if (remaining == 0) {
                return -1;
            }
            int n = Math.min(l, remaining);
            if (n > 0) {
                System.arraycopy(this.bytes(), this.offset(), b, o, n);
                this.position += n;
            }
            return n;
        }

        @Override
        public long skip(long n) {
            long n2 = Math.min(n, (long)this.available());
            this.position = (int)((long)this.position + n2);
            return n2;
        }

        @Override
        public int available() {
            return this.length() - this.position;
        }

        @Override
        public void mark(int readAheadLimit) {
            this.mark = this.position;
        }

        @Override
        public void reset() {
            this.position = this.mark;
        }

        @Override
        public Integer recordMark() {
            return this.position;
        }

        @Override
        public void resetToMark(Object m) {
            this.position = (Integer)m;
        }

        @Override
        public byte[] bytes() {
            return AbstractArrayIBytes.this.bytes();
        }

        @Override
        public int offset() {
            return AbstractArrayIBytes.this.offset() + this.position;
        }

        @Override
        public int length() {
            return AbstractArrayIBytes.this.length();
        }

        @Override
        public boolean nextBytesEqual(byte[] other) {
            return ArrayUtilities.arrayStartsWith(this.bytes(), this.offset(), this.length(), other, 0, other.length);
        }
    }
}

