/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.io.bytebuffer.serialisation;

import com.pushtechnology.diffusion.io.bytebuffer.serialisation.ByteBufferDeserialiser;
import com.pushtechnology.diffusion.io.bytebuffer.serialisation.DeserialisationException;
import com.pushtechnology.diffusion.utils.CharsetUtils;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;

public abstract class AbstractByteBufferDeserialiser
implements ByteBufferDeserialiser {
    @Override
    public final Object read(ByteBuffer source) throws DeserialisationException {
        try {
            return this.doRead(source);
        }
        catch (BufferUnderflowException e) {
            return ByteBufferDeserialiser.DeserialisationResult.INSUFFICIENT_DATA;
        }
    }

    protected abstract Object doRead(ByteBuffer var1) throws BufferUnderflowException, DeserialisationException;

    public static final String readString(ByteBuffer buffer) throws BufferUnderflowException, DeserialisationException {
        int length = buffer.getInt();
        if (length < 0) {
            throw new DeserialisationException("Negative string size");
        }
        byte[] bytes = new byte[length];
        buffer.get(bytes);
        return CharsetUtils.bytesUTF8ToString(bytes);
    }
}

