/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.io.base64;

import java.io.IOException;
import java.io.OutputStream;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public final class Base64OutputStream
extends OutputStream {
    private static final String CODES = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
    private int leftOverValue = 0;
    private int leftOverPos = 0;
    private final OutputStream out;

    public Base64OutputStream(OutputStream out) {
        this.out = out;
    }

    @Override
    public void write(int signedByte) throws IOException {
        int b = signedByte & 0xFF;
        if (this.leftOverPos == 0) {
            this.write(Base64OutputStream.getAsciiCharFromIndex(b >> 2));
            this.leftOverValue = b << 4 & 0x3F;
            this.leftOverPos = 1;
        } else if (this.leftOverPos == 1) {
            this.write(Base64OutputStream.getAsciiCharFromIndex(b >> 4 | this.leftOverValue));
            this.leftOverValue = b << 2 & 0x3F;
            this.leftOverPos = 2;
        } else {
            assert (this.leftOverPos == 2);
            this.write(Base64OutputStream.getAsciiCharFromIndex(b >> 6 | this.leftOverValue));
            this.write(Base64OutputStream.getAsciiCharFromIndex(b & 0x3F));
            this.leftOverPos = 0;
        }
    }

    private void write(byte b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void close() throws IOException {
        if (this.leftOverPos == 2) {
            this.write(Base64OutputStream.getAsciiCharFromIndex(this.leftOverValue));
            this.write((byte)61);
            this.leftOverPos = 0;
        } else if (this.leftOverPos == 1) {
            this.write(Base64OutputStream.getAsciiCharFromIndex(this.leftOverValue));
            this.write((byte)61);
            this.write((byte)61);
            this.leftOverPos = 0;
        }
    }

    private static byte getAsciiCharFromIndex(int index) {
        return (byte)CODES.charAt(index);
    }

    public static int encodedSize(int n) {
        return (n + 2) / 3 * 4;
    }

    public int encodedSizeWithPendingData(int n) {
        return (n + 2 + this.leftOverPos) / 3 * 4;
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }
}

