/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.http;

import com.pushtechnology.diffusion.io.http.ParseHTTPException;
import com.pushtechnology.diffusion.utils.ConfigurationUtils;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.function.BiConsumer;
import java.util.function.Predicate;

public final class HTTPHeaders {
    private static final String ISO_8859_1_NAME = "ISO-8859-1";
    private static final int MAX_HEADER_LENGTH = ConfigurationUtils.getIntegerSystemProperty("diffusion.http.maxheadersize", 16384);
    private static final char CR = '\r';
    private static final char LF = '\n';
    private static final char COLON = ':';
    private final int[] starts;
    private final String data;

    public static HTTPHeaders parseBuffer(ByteBuffer buffer) throws ParseHTTPException {
        int start;
        int line = 0;
        int lastHeader = start = buffer.position();
        boolean seenColon = false;
        while (buffer.remaining() >= 2) {
            byte b = buffer.get();
            if (b == 13) {
                if (buffer.get() != 10) {
                    throw HTTPHeaders.parseHTTPException("CR without LF", line);
                }
                int p = buffer.position();
                if (p == lastHeader + 2) {
                    if (line == 0) {
                        throw HTTPHeaders.parseHTTPException("No HTTP status line", line);
                    }
                    byte[] result = new byte[p - start];
                    buffer.position(start);
                    buffer.get(result, 0, p - start);
                    return new HTTPHeaders(HTTPHeaders.iso8859ToString(result), line + 1);
                }
                lastHeader = p;
                if (line > 0 && !seenColon) {
                    throw HTTPHeaders.parseHTTPException("Invalid header line", line);
                }
                ++line;
                seenColon = false;
                continue;
            }
            if (buffer.position() - lastHeader > MAX_HEADER_LENGTH) {
                throw HTTPHeaders.parseHTTPException("HTTP header is too long", line);
            }
            if (b != 58) continue;
            seenColon = true;
        }
        buffer.position(buffer.limit());
        return null;
    }

    private static ParseHTTPException parseHTTPException(String message, int line) {
        return new ParseHTTPException(message + " at line " + line);
    }

    private HTTPHeaders(String data, int lineCount) throws ParseHTTPException {
        this.data = data;
        int[] ss = new int[lineCount];
        int l = 0;
        for (int i = 0; i < data.length(); ++i) {
            if (data.charAt(i) != '\r') continue;
            assert (data.charAt(i + 1) == '\n');
            ss[l] = i + 2;
            ++l;
        }
        this.starts = ss;
    }

    public String getFirstLine() {
        return this.data.substring(0, this.starts[0] - 2);
    }

    public int getNumberOfHeaders() {
        return this.starts.length - 2;
    }

    public int size() {
        return this.data.length();
    }

    public String find(String key) {
        int keyLength = key.length();
        for (int i = 0; i < this.starts.length - 1; ++i) {
            int s = this.starts[i];
            if (!this.data.regionMatches(true, s, key, 0, keyLength) || this.data.charAt(s + keyLength) != ':') continue;
            String value = this.data.substring(s + keyLength + 1, this.starts[i + 1] - 2);
            return value.trim();
        }
        return null;
    }

    public boolean hasHeaderMatching(String key, Predicate<String> valueMatcher) {
        int keyLength = key.length();
        for (int i = 0; i < this.starts.length - 1; ++i) {
            String value;
            int s = this.starts[i];
            if (!this.data.regionMatches(true, s, key, 0, keyLength) || this.data.charAt(s + keyLength) != ':' || !valueMatcher.test(value = this.data.substring(s + keyLength + 1, this.starts[i + 1] - 2))) continue;
            return true;
        }
        return false;
    }

    public void forEach(BiConsumer<String, String> consumer) {
        for (int i = 0; i < this.starts.length - 2; ++i) {
            int s = this.starts[i];
            int e = this.starts[i + 1] - 2;
            int colon = this.data.indexOf(58, s);
            consumer.accept(this.data.substring(s, colon), this.data.substring(colon + 1, e).trim());
        }
    }

    public String toString() {
        return this.data;
    }

    private static String iso8859ToString(byte[] bytes) {
        return HTTPHeaders.iso8859ToString(bytes, 0, bytes.length);
    }

    private static String iso8859ToString(byte[] bytes, int offset, int length) {
        try {
            return new String(bytes, offset, length, ISO_8859_1_NAME);
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }
}

