/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.gateway.control;

import com.pushtechnology.diffusion.client.features.impl.AbstractFeature;
import com.pushtechnology.diffusion.client.internal.session.InternalSession;
import com.pushtechnology.diffusion.client.session.Session;
import com.pushtechnology.diffusion.client.session.SessionId;
import com.pushtechnology.diffusion.command.commands.gateway.GatewayClientDetailList;
import com.pushtechnology.diffusion.command.commands.gateway.GatewayClientDetailListRequest;
import com.pushtechnology.diffusion.command.commands.gateway.GatewayClientKey;
import com.pushtechnology.diffusion.command.commands.gateway.GatewayClientList;
import com.pushtechnology.diffusion.command.commands.gateway.GatewayClientRequest;
import com.pushtechnology.diffusion.command.commands.gateway.GatewayResponse;
import com.pushtechnology.diffusion.command.commands.gateway.configuration.GetConfigurationRequest;
import com.pushtechnology.diffusion.command.commands.gateway.operations.GetOperationDetailRequest;
import com.pushtechnology.diffusion.command.commands.gateway.operations.GetOperationsRequest;
import com.pushtechnology.diffusion.command.commands.gateway.operations.InvokeOperationRequest;
import com.pushtechnology.diffusion.command.commands.gateway.services.AddServiceRequest;
import com.pushtechnology.diffusion.command.commands.gateway.services.AddServiceResponse;
import com.pushtechnology.diffusion.command.commands.gateway.services.GatewayServiceDetail;
import com.pushtechnology.diffusion.command.commands.gateway.services.GatewayServiceId;
import com.pushtechnology.diffusion.command.commands.gateway.services.GetServiceConfigurationRequest;
import com.pushtechnology.diffusion.command.commands.gateway.services.GetServiceOperationDetailRequest;
import com.pushtechnology.diffusion.command.commands.gateway.services.GetServiceOperationsRequest;
import com.pushtechnology.diffusion.command.commands.gateway.services.GetServiceStatusRequest;
import com.pushtechnology.diffusion.command.commands.gateway.services.GetServiceTypesRequest;
import com.pushtechnology.diffusion.command.commands.gateway.services.GetServicesRequest;
import com.pushtechnology.diffusion.command.commands.gateway.services.InvokeServiceOperationRequest;
import com.pushtechnology.diffusion.command.commands.gateway.services.RemoveServiceRequest;
import com.pushtechnology.diffusion.command.commands.gateway.services.UpdateServiceRequest;
import com.pushtechnology.diffusion.command.commands.gateway.services.UpdateServiceResponse;
import com.pushtechnology.diffusion.command.commands.gateway.status.GetStatusRequest;
import com.pushtechnology.diffusion.command.sender.ServiceLocator;
import com.pushtechnology.diffusion.command.sender.ServiceReference;
import com.pushtechnology.diffusion.command.services.definition.CommonServices;
import com.pushtechnology.diffusion.gateway.Gateway;
import com.pushtechnology.diffusion.gateway.control.GatewayControl;
import com.pushtechnology.diffusion.java7.Functions;
import com.pushtechnology.diffusion.session.impl.InternalSessionId;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.jcip.annotations.Immutable;

@Immutable
public final class GatewayControlImpl
extends AbstractFeature
implements GatewayControl {
    private final ServiceReference<GatewayClientRequest, GatewayResponse> theRequestService;
    private final ServiceReference<GatewayClientKey, Void> theRegisterClientService;
    private final ServiceReference<GatewayClientKey, Void> theRemoveClientService;
    private final ServiceReference<Void, GatewayClientList> theGetClientsService;
    private final ServiceReference<GatewayClientDetailListRequest, GatewayClientDetailList> theGetClientDetailListService;

    public GatewayControlImpl(Session session, InternalSession internalSession) {
        super(session, internalSession);
        ServiceLocator serviceLocator = internalSession.getServiceLocator();
        this.theRequestService = serviceLocator.obtainService(CommonServices.GATEWAY_CLIENT_REQUEST);
        this.theRegisterClientService = serviceLocator.obtainService(CommonServices.REGISTER_GATEWAY_CLIENT);
        this.theGetClientsService = serviceLocator.obtainService(CommonServices.GET_GATEWAY_CLIENTS);
        this.theRemoveClientService = serviceLocator.obtainService(CommonServices.REMOVE_GATEWAY_CLIENT);
        this.theGetClientDetailListService = serviceLocator.obtainService(CommonServices.GET_GATEWAY_CLIENT_DETAIL_LIST);
    }

    @Override
    public CompletableFuture<GatewayControl.ClientConfiguration> getConfiguration(SessionId sessionId) {
        GatewayClientRequest request = new GatewayClientRequest(Objects.requireNonNull((InternalSessionId)sessionId, "sessionId is null"), GetConfigurationRequest.GET_CONFIGURATION_REQUEST);
        return this.theRequestService.sendCommand(request).thenApply(response -> (GatewayControl.ClientConfiguration)((Object)response));
    }

    @Override
    public CompletableFuture<GatewayControl.ClientStatus> getStatus(SessionId sessionId) {
        GatewayClientRequest request = new GatewayClientRequest(Objects.requireNonNull((InternalSessionId)sessionId, "sessionId is null"), GetStatusRequest.GET_STATUS_REQUEST);
        return this.theRequestService.sendCommand(request).thenApply(response -> (GatewayControl.ClientStatus)((Object)response));
    }

    @Override
    public CompletableFuture<GatewayControl.ClientOperations> getOperations(SessionId sessionId) {
        GatewayClientRequest request = new GatewayClientRequest(Objects.requireNonNull((InternalSessionId)sessionId, "sessionId is null"), GetOperationsRequest.GET_OPERATIONS_REQUEST);
        return this.theRequestService.sendCommand(request).thenApply(response -> (GatewayControl.ClientOperations)((Object)response));
    }

    @Override
    public CompletableFuture<Gateway.OperationDetail> getOperationDetail(SessionId sessionId, String operationName) {
        GatewayClientRequest request = new GatewayClientRequest(Objects.requireNonNull((InternalSessionId)sessionId, "sessionId is null"), new GetOperationDetailRequest(Objects.requireNonNull(operationName, "operationName is null")));
        return this.theRequestService.sendCommand(request).thenApply(response -> (Gateway.OperationDetail)((Object)response));
    }

    @Override
    public CompletableFuture<GatewayControl.OperationResponse> invokeOperation(SessionId sessionId, String operationName, String input) {
        GatewayClientRequest request = new GatewayClientRequest(Objects.requireNonNull((InternalSessionId)sessionId, "sessionId is null"), new InvokeOperationRequest(Objects.requireNonNull(operationName, "operationName is null"), input));
        return this.theRequestService.sendCommand(request).thenApply(response -> (GatewayControl.OperationResponse)((Object)response));
    }

    @Override
    public CompletableFuture<List<GatewayControl.ClientKey>> getClients() {
        return this.theGetClientsService.sendCommand(null).thenApply(list -> Collections.unmodifiableList(list.getClients()));
    }

    @Override
    public CompletableFuture<List<GatewayControl.ClientDetail>> getClientDetails(Set<String> types, Set<String> ids) {
        return this.theGetClientDetailListService.sendCommand(new GatewayClientDetailListRequest(types, ids)).thenApply(list -> Collections.unmodifiableList(list.getGatewayClientDetails()));
    }

    @Override
    public CompletableFuture<?> registerClient(String type, String id) {
        return this.theRegisterClientService.sendCommand(new GatewayClientKey(Objects.requireNonNull(type, "type is null"), Objects.requireNonNull(id, "id is null"))).thenApply(Functions.identity());
    }

    @Override
    public CompletableFuture<?> removeClient(String type, String id) {
        return this.theRemoveClientService.sendCommand(new GatewayClientKey(Objects.requireNonNull(type, "type is null"), Objects.requireNonNull(id, "id is null"))).thenApply(Functions.identity());
    }

    @Override
    public CompletableFuture<GatewayControl.ClientServiceTypes> getServiceTypes(SessionId sessionId) {
        GatewayClientRequest request = new GatewayClientRequest(Objects.requireNonNull((InternalSessionId)sessionId, "sessionId is null"), GetServiceTypesRequest.GET_SERVICE_TYPES_REQUEST);
        return this.theRequestService.sendCommand(request).thenApply(response -> (GatewayControl.ClientServiceTypes)((Object)response));
    }

    @Override
    public CompletableFuture<GatewayControl.ClientServices> getServices(SessionId sessionId) {
        GatewayClientRequest request = new GatewayClientRequest(Objects.requireNonNull((InternalSessionId)sessionId, "sessionId is null"), GetServicesRequest.GET_SERVICES_REQUEST);
        return this.theRequestService.sendCommand(request).thenApply(response -> (GatewayControl.ClientServices)((Object)response));
    }

    @Override
    public CompletableFuture<GatewayControl.ClientConfiguration> getServiceConfiguration(SessionId sessionId, Gateway.ServiceId serviceId) {
        GatewayClientRequest request = new GatewayClientRequest(Objects.requireNonNull((InternalSessionId)sessionId, "sessionId is null"), new GetServiceConfigurationRequest(Objects.requireNonNull(serviceId, "serviceId is null")));
        return this.theRequestService.sendCommand(request).thenApply(response -> (GatewayControl.ClientConfiguration)((Object)response));
    }

    @Override
    public CompletableFuture<GatewayControl.ClientStatus> getServiceStatus(SessionId sessionId, Gateway.ServiceId serviceId) {
        GatewayClientRequest request = new GatewayClientRequest(Objects.requireNonNull((InternalSessionId)sessionId, "sessionId is null"), new GetServiceStatusRequest(Objects.requireNonNull(serviceId, "serviceId is null")));
        return this.theRequestService.sendCommand(request).thenApply(response -> (GatewayControl.ClientStatus)((Object)response));
    }

    @Override
    public CompletableFuture<GatewayControl.ClientOperations> getServiceOperations(SessionId sessionId, Gateway.ServiceId serviceId) {
        GatewayClientRequest request = new GatewayClientRequest(Objects.requireNonNull((InternalSessionId)sessionId, "sessionId is null"), new GetServiceOperationsRequest(Objects.requireNonNull(serviceId, "serviceId is null")));
        return this.theRequestService.sendCommand(request).thenApply(response -> (GatewayControl.ClientOperations)((Object)response));
    }

    @Override
    public CompletableFuture<Gateway.OperationDetail> getServiceOperationDetail(SessionId sessionId, Gateway.ServiceId serviceId, String operationName) {
        GatewayClientRequest request = new GatewayClientRequest(Objects.requireNonNull((InternalSessionId)sessionId, "sessionId is null"), new GetServiceOperationDetailRequest(Objects.requireNonNull(serviceId, "serviceId is null"), Objects.requireNonNull(operationName, "operationName is null")));
        return this.theRequestService.sendCommand(request).thenApply(response -> (Gateway.OperationDetail)((Object)response));
    }

    @Override
    public CompletableFuture<GatewayControl.OperationResponse> invokeServiceOperation(SessionId sessionId, Gateway.ServiceId serviceId, String operationName, String input) {
        GatewayClientRequest request = new GatewayClientRequest(Objects.requireNonNull((InternalSessionId)sessionId, "sessionId is null"), new InvokeServiceOperationRequest(Objects.requireNonNull(serviceId, "serviceId is null"), Objects.requireNonNull(operationName, "operationName is null"), input));
        return this.theRequestService.sendCommand(request).thenApply(response -> (GatewayControl.OperationResponse)((Object)response));
    }

    @Override
    public CompletableFuture<Gateway.ServiceDetail> addService(SessionId sessionId, String serviceType, String serviceName, String description, String configuration) {
        GatewayClientRequest request = new GatewayClientRequest(Objects.requireNonNull((InternalSessionId)sessionId, "sessionId is null"), new AddServiceRequest(new GatewayServiceDetail(new GatewayServiceId(Objects.requireNonNull(serviceType, "serviceType is null"), Objects.requireNonNull(serviceName, "serviceName is null")), Objects.requireNonNull(description, "description is null"), Objects.requireNonNull(configuration, "configuration is null"))));
        return this.theRequestService.sendCommand(request).thenApply(response -> ((AddServiceResponse)response).getServiceDetail());
    }

    @Override
    public CompletableFuture<Gateway.ServiceDetail> updateService(SessionId sessionId, Gateway.ServiceId serviceId, String description, String configuration) {
        if (description == null && configuration == null) {
            throw new IllegalArgumentException("At least one of description or configuration must be supplied");
        }
        GatewayClientRequest request = new GatewayClientRequest(Objects.requireNonNull((InternalSessionId)sessionId, "sessionId is null"), new UpdateServiceRequest(new GatewayServiceDetail(Objects.requireNonNull(serviceId, "serviceId is null"), description, configuration)));
        return this.theRequestService.sendCommand(request).thenApply(response -> ((UpdateServiceResponse)response).getServiceDetail());
    }

    @Override
    public CompletableFuture<?> removeService(SessionId sessionId, Gateway.ServiceId serviceId) {
        GatewayClientRequest request = new GatewayClientRequest(Objects.requireNonNull((InternalSessionId)sessionId, "sessionId is null"), new RemoveServiceRequest(Objects.requireNonNull(serviceId, "serviceId is null")));
        return this.theRequestService.sendCommand(request).thenApply(Functions.identity());
    }
}

