/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.gateway;

import com.pushtechnology.diffusion.command.ErrorReasonException;
import com.pushtechnology.diffusion.command.commands.gateway.GatewayResponse;
import com.pushtechnology.diffusion.command.commands.gateway.services.UpdateServiceRequest;
import com.pushtechnology.diffusion.command.commands.gateway.services.UpdateServiceResponse;
import com.pushtechnology.diffusion.command.receiver.CommandService;
import com.pushtechnology.diffusion.gateway.AbstractGatewayResponder;
import com.pushtechnology.diffusion.gateway.Gateway;
import com.pushtechnology.diffusion.gateway.GatewayRegistry;
import com.pushtechnology.diffusion.gateway.GatewayRequestHandler;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
final class UpdateServiceRequestHandler
implements GatewayRequestHandler<UpdateServiceRequest> {
    private final GatewayRegistry theRegistry;

    UpdateServiceRequestHandler(GatewayRegistry registry) {
        this.theRegistry = registry;
    }

    @Override
    public void handleRequest(UpdateServiceRequest request, Gateway.RequestStream requestStream, CommandService.ServiceCallback<GatewayResponse> callback) {
        Gateway.ServiceDetail detail = request.getServiceDetail();
        Gateway.ServiceId serviceId = detail.getId();
        if (!this.theRegistry.hasService(serviceId)) {
            callback.fail(ErrorReasonException.REJECTED_REQUEST, "Service '" + String.valueOf(serviceId) + "' is not known");
            return;
        }
        ((Gateway.ServiceRequestStream)requestStream).updateService(serviceId.getType(), serviceId.getName(), detail.getDescription(), detail.getConfiguration(), new UpdateServiceResponderImpl(callback));
    }

    private final class UpdateServiceResponderImpl
    extends AbstractGatewayResponder
    implements Gateway.UpdateServiceResponder {
        private UpdateServiceResponderImpl(CommandService.ServiceCallback<GatewayResponse> callback) {
            super(callback);
        }

        @Override
        public void respond(Gateway.Service service) {
            UpdateServiceRequestHandler.this.theRegistry.replaceService(Objects.requireNonNull(service, "service is null"));
            this.respond(new UpdateServiceResponse(service.getDetail()));
        }
    }
}

