/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.gateway;

import com.pushtechnology.diffusion.command.commands.gateway.GatewayResponse;
import com.pushtechnology.diffusion.command.commands.gateway.services.GatewayServiceDetail;
import com.pushtechnology.diffusion.command.commands.gateway.services.GetServicesRequest;
import com.pushtechnology.diffusion.command.commands.gateway.services.GetServicesResponse;
import com.pushtechnology.diffusion.command.receiver.CommandService;
import com.pushtechnology.diffusion.gateway.AbstractGatewayResponder;
import com.pushtechnology.diffusion.gateway.Gateway;
import com.pushtechnology.diffusion.gateway.GatewayRegistry;
import com.pushtechnology.diffusion.gateway.GatewayRequestHandler;
import java.util.ArrayList;
import java.util.List;
import net.jcip.annotations.Immutable;

@Immutable
final class GetServicesRequestHandler
implements GatewayRequestHandler<GetServicesRequest> {
    private final GatewayRegistry theRegistry;

    GetServicesRequestHandler(GatewayRegistry registry) {
        this.theRegistry = registry;
    }

    @Override
    public void handleRequest(GetServicesRequest request, Gateway.RequestStream requestStream, CommandService.ServiceCallback<GatewayResponse> callback) {
        List<Gateway.Service> services = this.theRegistry.getServices();
        ArrayList<Gateway.ServiceDetail> serviceDetails = new ArrayList<Gateway.ServiceDetail>();
        services.forEach(service -> {
            ServiceConfigurationResponder configurationResponder = new ServiceConfigurationResponder(callback);
            service.getRequestStream().getConfiguration(configurationResponder);
            Gateway.ServiceDetail serviceDetail = service.getDetail();
            serviceDetails.add(new GatewayServiceDetail(serviceDetail.getId(), serviceDetail.getDescription(), configurationResponder.configuration));
        });
        callback.respond(new GetServicesResponse(serviceDetails));
    }

    private static final class ServiceConfigurationResponder
    extends AbstractGatewayResponder
    implements Gateway.ConfigurationResponder {
        private String configuration;

        private ServiceConfigurationResponder(CommandService.ServiceCallback<GatewayResponse> callback) {
            super(callback);
        }

        @Override
        public void respond(String schemaResponse, String configurationResponse) {
            this.configuration = configurationResponse;
        }
    }
}

