/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.gateway;

import com.pushtechnology.diffusion.client.callbacks.ErrorReason;
import com.pushtechnology.diffusion.client.internal.session.InternalSession;
import com.pushtechnology.diffusion.command.ErrorReasonException;
import com.pushtechnology.diffusion.command.commands.gateway.GatewayRequest;
import com.pushtechnology.diffusion.command.commands.gateway.GatewayRequestType;
import com.pushtechnology.diffusion.command.commands.gateway.GatewayResponse;
import com.pushtechnology.diffusion.command.commands.gateway.ServiceGatewayRequest;
import com.pushtechnology.diffusion.command.receiver.CommandService;
import com.pushtechnology.diffusion.gateway.AddServiceRequestHandler;
import com.pushtechnology.diffusion.gateway.Gateway;
import com.pushtechnology.diffusion.gateway.GatewayRegistry;
import com.pushtechnology.diffusion.gateway.GatewayRequestHandler;
import com.pushtechnology.diffusion.gateway.GetConfigurationRequestHandler;
import com.pushtechnology.diffusion.gateway.GetOperationDetailRequestHandler;
import com.pushtechnology.diffusion.gateway.GetOperationsRequestHandler;
import com.pushtechnology.diffusion.gateway.GetServiceTypesRequestHandler;
import com.pushtechnology.diffusion.gateway.GetServicesRequestHandler;
import com.pushtechnology.diffusion.gateway.GetStatusRequestHandler;
import com.pushtechnology.diffusion.gateway.InvokeOperationRequestHandler;
import com.pushtechnology.diffusion.gateway.RemoveServiceRequestHandler;
import com.pushtechnology.diffusion.gateway.UpdateServiceRequestHandler;
import com.pushtechnology.diffusion.logs.i18n.I18nLogger;
import java.util.HashMap;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public final class GatewayRequestService
implements CommandService<GatewayRequest, GatewayResponse, InternalSession> {
    private static final I18nLogger LOG = I18nLogger.getLogger(GatewayRequestService.class);
    private final Map<GatewayRequestType, GatewayRequestHandler> theRequestHandlers = new HashMap<GatewayRequestType, GatewayRequestHandler>();
    private final GatewayRegistry theRegistry;

    public GatewayRequestService(GatewayRegistry registry) {
        this.theRegistry = registry;
        GetConfigurationRequestHandler getConfigurationRequestHandler = new GetConfigurationRequestHandler();
        GetStatusRequestHandler getStatusRequestHandler = new GetStatusRequestHandler();
        GetOperationsRequestHandler getOperationsRequestHandler = new GetOperationsRequestHandler();
        GetOperationDetailRequestHandler getOperationDetailRequestHandler = new GetOperationDetailRequestHandler();
        InvokeOperationRequestHandler invokeOperationRequestHandler = new InvokeOperationRequestHandler();
        this.theRequestHandlers.put(GatewayRequestType.GET_CONFIGURATION, getConfigurationRequestHandler);
        this.theRequestHandlers.put(GatewayRequestType.GET_STATUS, getStatusRequestHandler);
        this.theRequestHandlers.put(GatewayRequestType.GET_OPERATIONS, getOperationsRequestHandler);
        this.theRequestHandlers.put(GatewayRequestType.GET_OPERATION_DETAIL, getOperationDetailRequestHandler);
        this.theRequestHandlers.put(GatewayRequestType.INVOKE_OPERATION, invokeOperationRequestHandler);
        this.theRequestHandlers.put(GatewayRequestType.ADD_SERVICE, new AddServiceRequestHandler(registry));
        this.theRequestHandlers.put(GatewayRequestType.UPDATE_SERVICE, new UpdateServiceRequestHandler(registry));
        this.theRequestHandlers.put(GatewayRequestType.REMOVE_SERVICE, new RemoveServiceRequestHandler(registry));
        this.theRequestHandlers.put(GatewayRequestType.GET_SERVICE_TYPES, new GetServiceTypesRequestHandler(registry));
        this.theRequestHandlers.put(GatewayRequestType.GET_SERVICES, new GetServicesRequestHandler(registry));
        this.theRequestHandlers.put(GatewayRequestType.GET_SERVICE_CONFIGURATION, getConfigurationRequestHandler);
        this.theRequestHandlers.put(GatewayRequestType.GET_SERVICE_STATUS, getStatusRequestHandler);
        this.theRequestHandlers.put(GatewayRequestType.GET_SERVICE_OPERATIONS, getOperationsRequestHandler);
        this.theRequestHandlers.put(GatewayRequestType.GET_SERVICE_OPERATION_DETAIL, getOperationDetailRequestHandler);
        this.theRequestHandlers.put(GatewayRequestType.INVOKE_SERVICE_OPERATION, invokeOperationRequestHandler);
    }

    @Override
    public void onRequest(InternalSession session, GatewayRequest request, CommandService.ServiceCallback<GatewayResponse> callback) {
        Gateway.RequestStream requestStream;
        Gateway.RequestStream mainRequestStream = this.theRegistry.getRequestStream();
        if (mainRequestStream == null) {
            LOG.debug("There is no request stream");
            callback.fail(ErrorReason.NO_SUCH_SESSION, "Session " + String.valueOf(session.getSessionId()) + " has no gateway request stream");
            return;
        }
        GatewayRequestType requestType = request.getType();
        if (requestType.needsServiceSupport()) {
            if (!(mainRequestStream instanceof Gateway.ServiceRequestStream)) {
                callback.fail(ErrorReasonException.REJECTED_REQUEST, "Session " + String.valueOf(session.getSessionId()) + " does not support services");
                return;
            }
            if (requestType.isServiceSpecific()) {
                Gateway.ServiceId serviceId = ((ServiceGatewayRequest)request).getServiceId();
                requestStream = this.theRegistry.getServiceRequestStream(serviceId);
                if (requestStream == null) {
                    callback.fail(ErrorReasonException.REJECTED_REQUEST, "Session " + String.valueOf(session.getSessionId()) + " does not have service '" + String.valueOf(serviceId) + "'");
                    return;
                }
            } else {
                requestStream = mainRequestStream;
            }
        } else {
            requestStream = mainRequestStream;
        }
        try {
            this.theRequestHandlers.get((Object)requestType).handleRequest(request, requestStream, callback);
        }
        catch (RuntimeException ex) {
            LOG.error("Exception from " + String.valueOf(mainRequestStream), (Throwable)ex);
            callback.fail(ErrorReasonException.REJECTED_REQUEST, ex.toString());
        }
    }
}

