/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.gateway;

import com.pushtechnology.diffusion.client.features.impl.AbstractFeature;
import com.pushtechnology.diffusion.client.internal.session.ClosedSessionListener;
import com.pushtechnology.diffusion.client.internal.session.InternalSession;
import com.pushtechnology.diffusion.client.session.Session;
import com.pushtechnology.diffusion.command.commands.gateway.GatewayClient;
import com.pushtechnology.diffusion.command.commands.gateway.GatewayClientKey;
import com.pushtechnology.diffusion.command.commands.gateway.GatewayRegistrationResponse;
import com.pushtechnology.diffusion.command.commands.gateway.GatewayValidationRequest;
import com.pushtechnology.diffusion.command.sender.ServiceLocator;
import com.pushtechnology.diffusion.command.sender.ServiceReference;
import com.pushtechnology.diffusion.command.services.definition.CommonServices;
import com.pushtechnology.diffusion.gateway.Gateway;
import com.pushtechnology.diffusion.gateway.GatewayRegistry;
import com.pushtechnology.diffusion.java7.Functions;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public final class GatewayImpl
extends AbstractFeature
implements Gateway {
    private final GatewayClientKey theClientKey;
    private final GatewayRegistry theRegistry;
    private final ServiceReference<GatewayValidationRequest, Gateway.GatewayValidationResponse> theValidationService;
    private final ServiceReference<GatewayClient, GatewayRegistrationResponse> theRegistrationService;
    private final ServiceReference<GatewayClient, Void> theSaveConfigurationService;

    public GatewayImpl(Session session, InternalSession internalSession, GatewayRegistry registry) {
        super(session, internalSession);
        this.theRegistry = registry;
        ServiceLocator services = internalSession.getServiceLocator();
        this.theValidationService = services.obtainService(CommonServices.GATEWAY_VALIDATION);
        this.theRegistrationService = services.obtainService(CommonServices.GATEWAY_REGISTRATION);
        this.theSaveConfigurationService = services.obtainService(CommonServices.GATEWAY_SAVE_CONFIGURATION);
        Map<String, String> sessionProperties = internalSession.getProposedSessionProperties();
        this.theClientKey = new GatewayClientKey(sessionProperties.get("$GatewayType"), sessionProperties.get("$GatewayId"));
        internalSession.addListener(new ClosedSessionListener(){

            @Override
            public void onClosed() {
                GatewayImpl.this.theRegistry.deregister();
            }
        });
    }

    @Override
    public CompletableFuture<Gateway.GatewayValidationResponse> validate(Gateway.ConfigurationMode configurationMode, byte[] hash) {
        return this.theValidationService.sendCommand(new GatewayValidationRequest(this.theClientKey, Objects.requireNonNull(configurationMode, "configurationMode is null"), Objects.requireNonNull(hash, "hash is null"))).thenApply(Functions.identity());
    }

    @Override
    public CompletableFuture<Gateway.Registration> register(Gateway.RequestStream requestStream) {
        return this.register(requestStream, "", "");
    }

    @Override
    public CompletableFuture<Gateway.Registration> register(Gateway.RequestStream requestStream, String schema, String configuration) {
        this.theRegistry.validateRegister(requestStream);
        return this.theRegistrationService.sendCommand(new GatewayClient(this.theClientKey, Objects.requireNonNull(schema, "schema is null"), Objects.requireNonNull(configuration, "configuration is null"))).thenApply(response -> new RegistrationImpl(requestStream, (GatewayRegistrationResponse)response));
    }

    @Override
    public CompletableFuture<Gateway.ServiceRegistration> register(Gateway.ServiceRequestStream requestStream, List<Gateway.ServiceType> serviceTypes) {
        return this.register(requestStream, serviceTypes, "", "");
    }

    @Override
    public CompletableFuture<Gateway.ServiceRegistration> register(Gateway.ServiceRequestStream requestStream, List<Gateway.ServiceType> serviceTypes, String schema, String configuration) {
        this.theRegistry.validateRegister(requestStream, serviceTypes);
        return this.theRegistrationService.sendCommand(new GatewayClient(this.theClientKey, Objects.requireNonNull(schema, "schema is null"), Objects.requireNonNull(configuration, "configuration is null"))).thenApply(response -> new ServiceRegistrationImpl(requestStream, serviceTypes, (GatewayRegistrationResponse)response));
    }

    @Override
    public synchronized CompletableFuture<?> saveConfiguration(String schema, String configuration) {
        if (this.theRegistry.getRequestStream() == null) {
            throw new IllegalStateException("Configuration may only be saved after registration");
        }
        return this.theSaveConfigurationService.sendCommand(new GatewayClient(this.theClientKey, Objects.requireNonNull(schema, "schema is null"), Objects.requireNonNull(configuration, "configuration is null"))).thenApply(Functions.identity());
    }

    private final class ServiceRegistrationImpl
    extends AbstractRegistrationImpl
    implements Gateway.ServiceRegistration {
        private final Gateway.ServiceRequestStream theRequestStream;
        private final List<Gateway.ServiceType> theServiceTypes;

        private ServiceRegistrationImpl(Gateway.ServiceRequestStream requestStream, List<Gateway.ServiceType> serviceTypes, GatewayRegistrationResponse response) {
            super(response);
            this.theRequestStream = requestStream;
            this.theServiceTypes = serviceTypes;
        }

        @Override
        public void complete(List<Gateway.Service> services) {
            GatewayImpl.this.theRegistry.register(this.theRequestStream, this.theServiceTypes, services);
        }
    }

    private final class RegistrationImpl
    extends AbstractRegistrationImpl
    implements Gateway.Registration {
        private final Gateway.RequestStream theRequestStream;

        private RegistrationImpl(Gateway.RequestStream requestStream, GatewayRegistrationResponse response) {
            super(response);
            this.theRequestStream = requestStream;
        }

        @Override
        public void complete() {
            GatewayImpl.this.theRegistry.register(this.theRequestStream);
        }
    }

    private abstract class AbstractRegistrationImpl
    implements Gateway.AbstractRegistration {
        private final String theSchema;
        private final String theConfiguration;

        private AbstractRegistrationImpl(GatewayRegistrationResponse response) {
            GatewayClient client = response.getGatewayClient();
            if (client == null) {
                throw new Gateway.GatewayRegistrationException(response.getErrorCode());
            }
            this.theSchema = client.getSchema();
            this.theConfiguration = client.getConfiguration();
        }

        @Override
        public final String getSchema() {
            return this.theSchema;
        }

        @Override
        public final String getConfiguration() {
            return this.theConfiguration;
        }
    }
}

