/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.gateway;

import com.pushtechnology.diffusion.client.callbacks.ErrorReason;
import com.pushtechnology.diffusion.client.callbacks.Stream;
import com.pushtechnology.diffusion.client.session.Feature;
import com.pushtechnology.diffusion.client.session.SessionException;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Gateway
extends Feature {
    public CompletableFuture<GatewayValidationResponse> validate(ConfigurationMode var1, byte[] var2);

    public CompletableFuture<Registration> register(RequestStream var1);

    public CompletableFuture<Registration> register(RequestStream var1, String var2, String var3);

    public CompletableFuture<ServiceRegistration> register(ServiceRequestStream var1, List<ServiceType> var2);

    public CompletableFuture<ServiceRegistration> register(ServiceRequestStream var1, List<ServiceType> var2, String var3, String var4);

    public CompletableFuture<?> saveConfiguration(String var1, String var2);

    public static final class GatewayRegistrationException
    extends SessionException {
        private static final long serialVersionUID = 896937734075529711L;
        private final ErrorCode theErrorCode;

        public GatewayRegistrationException(ErrorCode errorCode) {
            super(errorCode.getMessage());
            this.theErrorCode = errorCode;
        }

        public ErrorCode getErrorCode() {
            return this.theErrorCode;
        }

        public static enum ErrorCode {
            DUPLICATE_CLIENT_REGISTRATION("A gateway client with the same type and id is already registered");

            private final String theMessage;

            private ErrorCode(String message) {
                this.theMessage = message;
            }

            public String getMessage() {
                return this.name() + " : " + this.theMessage;
            }
        }
    }

    public static enum GatewayValidationResponse {
        VALID_ACTIVE,
        VALID_PASSIVE,
        VALIDATION_FAILED;

    }

    public static enum ConfigurationMode {
        STATIC,
        DYNAMIC;

    }

    public static interface ServiceRegistration
    extends AbstractRegistration {
        public void complete(List<Service> var1);
    }

    public static interface Registration
    extends AbstractRegistration {
        public void complete();
    }

    public static interface AbstractRegistration {
        public String getSchema();

        public String getConfiguration();
    }

    public static interface ServiceId {
        public String getType();

        public String getName();
    }

    public static interface ServiceDetail {
        public ServiceId getId();

        public String getDescription();

        public String getConfiguration();
    }

    public static interface Service {
        public ServiceDetail getDetail();

        public RequestStream getRequestStream();
    }

    public static interface ServiceType {
        public String getName();

        public String getDescription();

        public String getSchema();

        public boolean isSharedConfig();
    }

    public static interface OperationDetail {
        public String getDescription();

        public String getInputSchema();

        public String getOutputSchema();
    }

    public static interface Operation {
        public String getName();

        public String getSummary();
    }

    public static interface StatusItem {
        public Level getLevel();

        public Instant getTimestamp();

        public String getTitle();

        public String getDescription();

        public static enum Level {
            GREEN,
            AMBER,
            RED;

        }
    }

    public static interface RemoveServiceResponder
    extends Responder {
        public void respond();
    }

    public static interface UpdateServiceResponder
    extends Responder {
        public void respond(Service var1);
    }

    public static interface AddServiceResponder
    extends Responder {
        public void respond(Service var1);
    }

    public static interface InvocationResponder
    extends Responder {
        public void respond(String var1);
    }

    public static interface OperationDetailResponder
    extends Responder {
        public void respond(OperationDetail var1);
    }

    public static interface OperationsResponder
    extends Responder {
        public void respond(List<Operation> var1);
    }

    public static interface StatusResponder
    extends Responder {
        public void respond(List<StatusItem> var1);
    }

    public static interface ConfigurationResponder
    extends Responder {
        public void respond(String var1, String var2);
    }

    public static interface Responder {
        public void fail(String var1);
    }

    public static interface ServiceRequestStream
    extends RequestStream {
        default public void addService(String serviceType, String serviceName, String description, String configuration, AddServiceResponder responder) {
            responder.fail("Adding a service is not supported");
        }

        default public void updateService(String serviceType, String serviceName, String description, String configuration, UpdateServiceResponder responder) {
            responder.fail("Updating a service is not supported");
        }

        default public void removeService(String serviceType, String serviceName, RemoveServiceResponder responder) {
            responder.fail("Removing a service is not supported");
        }
    }

    public static interface RequestStream
    extends Stream {
        public static final Logger LOG = LoggerFactory.getLogger(RequestStream.class);

        default public void getConfiguration(ConfigurationResponder responder) {
            responder.respond("", "");
        }

        default public void getStatus(StatusResponder responder) {
            responder.respond(Collections.emptyList());
        }

        default public void getOperations(OperationsResponder responder) {
            responder.respond(Collections.emptyList());
        }

        default public void getOperationDetail(String operationName, OperationDetailResponder responder) {
            responder.fail("Operation '" + operationName + "' does not exist");
        }

        default public void invokeOperation(String operationName, String input, InvocationResponder responder) {
            responder.fail("Operation '" + operationName + "' does not exist");
        }

        @Override
        default public void onClose() {
            LOG.debug("RequestStream closed");
        }

        @Override
        default public void onError(ErrorReason errorReason) {
            LOG.warn("RequestStream error " + String.valueOf(errorReason));
        }
    }
}

