/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.gateway;

import com.pushtechnology.diffusion.client.session.SessionFactory;
import com.pushtechnology.diffusion.gateway.Gateway;
import java.time.Instant;

public enum DiffusionGateway {
    IMPLEMENTATION;

    private Implementation delegate;
    public static final int DEFAULT_INPUT_BUFFER_SIZE = 524288;
    public static final int DEFAULT_OUTPUT_BUFFER_SIZE = 524288;
    public static final int DEFAULT_MAXIMUM_QUEUE_SIZE = 10000;

    private DiffusionGateway() {
        String implementation = "com.pushtechnology.diffusion.client.impl.GatewayImplementation";
        try {
            Class<?> clazz = ((Object)((Object)this)).getClass().getClassLoader().loadClass("com.pushtechnology.diffusion.client.impl.GatewayImplementation");
            this.delegate = (Implementation)clazz.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static SessionFactory sessions(String gatewayType, String gatewayId) {
        return DiffusionGateway.IMPLEMENTATION.delegate.newSessionFactory(gatewayType, gatewayId);
    }

    public static Gateway.StatusItem newStatusItem(Gateway.StatusItem.Level level, Instant timestamp, String title, String description) {
        return DiffusionGateway.IMPLEMENTATION.delegate.newStatusItem(level, timestamp, title, description);
    }

    public static Gateway.Operation newOperation(String name, String summary) {
        return DiffusionGateway.IMPLEMENTATION.delegate.newOperation(name, summary);
    }

    public static Gateway.OperationDetail newOperationDetail(String description, String inputSchema, String outputSchema) {
        return DiffusionGateway.IMPLEMENTATION.delegate.newOperationDetail(description, inputSchema, outputSchema);
    }

    public static Gateway.ServiceType newServiceType(String name, String description, String schema) {
        return DiffusionGateway.IMPLEMENTATION.delegate.newServiceType(name, description, schema, false);
    }

    public static Gateway.ServiceType newSharedConfigType(String name, String description, String schema) {
        return DiffusionGateway.IMPLEMENTATION.delegate.newServiceType(name, description, schema, true);
    }

    public static Gateway.Service newService(String serviceType, String name, String description, String configuration, Gateway.RequestStream requestStream) {
        return DiffusionGateway.IMPLEMENTATION.delegate.newService(serviceType, name, description, configuration, requestStream);
    }

    public static interface Implementation {
        public SessionFactory newSessionFactory(String var1, String var2);

        public Gateway.StatusItem newStatusItem(Gateway.StatusItem.Level var1, Instant var2, String var3, String var4);

        public Gateway.Operation newOperation(String var1, String var2);

        public Gateway.OperationDetail newOperationDetail(String var1, String var2, String var3);

        public Gateway.ServiceType newServiceType(String var1, String var2, String var3, boolean var4);

        public Gateway.Service newService(String var1, String var2, String var3, String var4, Gateway.RequestStream var5);
    }
}

