/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.flowcontrol;

import com.pushtechnology.diffusion.flowcontrol.CompositeFlowMeasurement;
import com.pushtechnology.diffusion.flowcontrol.FlowControl;
import com.pushtechnology.diffusion.flowcontrol.FlowControlBuilder;
import com.pushtechnology.diffusion.flowcontrol.FlowMeasurement;
import com.pushtechnology.diffusion.flowcontrol.PressureCalculator;
import com.pushtechnology.diffusion.flowcontrol.SleepingFlowControl;
import com.pushtechnology.diffusion.util.concurrent.threads.CommonThreadPools;
import com.pushtechnology.diffusion.utils.ConfigurationUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public final class SleepingFlowControlBuilder
implements FlowControlBuilder {
    private static final int SLEEP_TIME_MS = ConfigurationUtils.getIntegerSystemProperty("diffusion.flowcontrol.sleeptime", 100);
    private final PressureCalculator calculator;
    private final List<FlowMeasurement> measurements;
    private final CommonThreadPools threadPools;

    public SleepingFlowControlBuilder(PressureCalculator calculator, CommonThreadPools threadPools) {
        this(calculator, threadPools, Collections.emptyList());
    }

    private SleepingFlowControlBuilder(PressureCalculator calculator, CommonThreadPools threadPools, List<FlowMeasurement> measurements) {
        this.calculator = calculator;
        this.measurements = measurements;
        this.threadPools = threadPools;
    }

    @Override
    public FlowControlBuilder with(FlowMeasurement m) {
        ArrayList<FlowMeasurement> ms = new ArrayList<FlowMeasurement>(this.measurements.size() + 1);
        ms.addAll(this.measurements);
        ms.add(Objects.requireNonNull(m));
        return new SleepingFlowControlBuilder(this.calculator, this.threadPools, ms);
    }

    @Override
    public FlowControl build() {
        return new SleepingFlowControl(SLEEP_TIME_MS, this.calculator, new CompositeFlowMeasurement(this.measurements.toArray(new FlowMeasurement[0])), this.threadPools.getBackgroundThreadPool());
    }
}

