/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.flowcontrol;

import com.pushtechnology.diffusion.flowcontrol.PressureCalculator;
import net.jcip.annotations.Immutable;

@Immutable
public final class QuadraticBackOffCalculator
implements PressureCalculator {
    private final double lo;
    private final double hi;

    public QuadraticBackOffCalculator() {
        this(0.5, 1.0);
    }

    public QuadraticBackOffCalculator(double lo, double hi) {
        if (lo < 0.0 || lo > 1.0) {
            throw new IllegalArgumentException("Bad lo=" + lo);
        }
        if (hi < 0.0 || hi > 1.0) {
            throw new IllegalArgumentException("Bad hi=" + hi);
        }
        if (lo > hi) {
            throw new IllegalArgumentException("lo > hi");
        }
        this.lo = lo;
        this.hi = hi;
    }

    @Override
    public double toPressure(int size, int maxSize) {
        if (maxSize < 1) {
            throw new IllegalArgumentException("bad maxSize=" + maxSize);
        }
        double p = (double)size / (double)maxSize;
        if (p < this.lo) {
            return 0.0;
        }
        if (p >= this.hi) {
            return 1.0;
        }
        double ratio = (p - this.lo) / (this.hi - this.lo);
        return ratio * ratio;
    }

    public String toString() {
        return String.format("quadratic back off [%.2f, %.2f]", this.lo, this.hi);
    }
}

