/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.flowcontrol;

import com.pushtechnology.diffusion.flowcontrol.FlowMeasurement;
import com.pushtechnology.diffusion.flowcontrol.PressureCalculator;
import com.pushtechnology.diffusion.logs.i18n.I18nLogger;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;

@ThreadSafe
final class FlowMeasurementLogger
implements FlowMeasurement {
    private static final Logger LOG = I18nLogger.getLogger(FlowMeasurementLogger.class);
    private final FlowMeasurement delegate;
    private volatile double peak;

    FlowMeasurementLogger(FlowMeasurement delegate) {
        this.delegate = delegate;
    }

    public Runnable logTask() {
        return new Runnable(){
            private volatile Level last = null;

            @Override
            public void run() {
                int percent = (int)(FlowMeasurementLogger.this.peak * 100.0);
                FlowMeasurementLogger.this.peak = 0.0;
                Level level = Level.forPressure(percent);
                this.last = level.log(this.last, percent);
            }
        };
    }

    @Override
    public double toPressure(PressureCalculator calculator) {
        double pressure = this.delegate.toPressure(calculator);
        this.peak = Math.max(pressure, this.peak);
        return pressure;
    }

    public String toString() {
        return this.delegate.toString();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum Level {
        NORMAL(0){

            @Override
            Level log(Level last, int percent) {
                if (last == WARN && LOG.isWarnEnabled()) {
                    LOG.warn("FLOW_CONTROL_OFF");
                } else if (last == INFO && LOG.isInfoEnabled()) {
                    LOG.info("FLOW_CONTROL_OFF");
                }
                return null;
            }
        }
        ,
        INFO(50){

            @Override
            Level log(Level last, int percent) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("FLOW_CONTROL_PRESSURE", (Object)percent);
                    return INFO;
                }
                return null;
            }
        }
        ,
        WARN(100){

            @Override
            Level log(Level last, int percent) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("FLOW_CONTROL_PRESSURE", (Object)percent);
                    return WARN;
                }
                return null;
            }
        };

        private final int threshold;

        private Level(int threshold) {
            this.threshold = threshold;
        }

        abstract Level log(Level var1, int var2);

        static Level forPressure(int percent) {
            for (Level level : Level.values()) {
                if (percent > level.threshold) continue;
                return level;
            }
            return WARN;
        }
    }
}

