/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.flowcontrol;

import com.pushtechnology.diffusion.conversation.ConversationSet;
import com.pushtechnology.diffusion.flowcontrol.FlowMeasurement;
import com.pushtechnology.diffusion.flowcontrol.PressureCalculator;
import com.pushtechnology.diffusion.util.concurrent.threads.FastThreadLocal;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public final class ConversationSetFlowMeasurement
implements FlowMeasurement {
    private static final FastThreadLocal<Boolean> SUPPRESSED = FastThreadLocal.withInitial(() -> Boolean.FALSE);
    private volatile ConversationSet conversations;
    private final int maximumSize;

    public ConversationSetFlowMeasurement(ConversationSet conversations, int maximumSize) {
        this.conversations = conversations;
        this.maximumSize = maximumSize;
    }

    @Override
    public double toPressure(PressureCalculator calculator) {
        if (SUPPRESSED.get().booleanValue()) {
            return 0.0;
        }
        return calculator.toPressure(this.conversations.estimatedSize(), this.maximumSize);
    }

    public void setConversationSetToMeasure(ConversationSet conversationsToMeasure) {
        this.conversations = conversationsToMeasure;
    }

    public static void disableForThread() {
        SUPPRESSED.set(true);
    }

    public static void enableForThread() {
        SUPPRESSED.set(false);
    }

    public String toString() {
        ConversationSet currentConversations = this.conversations;
        return String.format("%s, size=%d, max=%d", currentConversations, currentConversations.estimatedSize(), this.maximumSize);
    }
}

