/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.datatype.recordv2.impl.schema;

import com.pushtechnology.diffusion.datatype.internal.JacksonContext;
import com.pushtechnology.diffusion.datatype.recordv2.impl.schema.SchemaBuilderImpl;
import com.pushtechnology.diffusion.datatype.recordv2.schema.Schema;
import com.pushtechnology.diffusion.datatype.recordv2.schema.SchemaBuilder;
import com.pushtechnology.diffusion.datatype.recordv2.schema.SchemaParseException;
import com.pushtechnology.diffusion.datatype.recordv2.schema.SchemaViolationException;
import com.pushtechnology.repackaged.jackson.core.JsonParser;
import com.pushtechnology.repackaged.jackson.core.JsonToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public final class SchemaParser {
    public Schema parse(String json) throws SchemaParseException {
        JsonParser jsonParser;
        try {
            jsonParser = JacksonContext.JSON_FACTORY.createParser(json);
        }
        catch (IOException ex) {
            throw new SchemaParseException("Unable to create parser", ex);
        }
        try {
            SchemaParser.parseStartObject(jsonParser);
            SchemaBuilderImpl builder = new SchemaBuilderImpl();
            while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                String name = SchemaParser.parseCurrentName(jsonParser);
                if ("records".equals(name)) {
                    SchemaParser.parseStartArray(jsonParser);
                    while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                        SchemaParser.parseRecord(jsonParser, builder);
                    }
                    continue;
                }
                throw new SchemaParseException("Unrecognised key '" + name + "' at " + String.valueOf(jsonParser.currentLocation()));
            }
            jsonParser.close();
            return builder.build();
        }
        catch (SchemaParseException | SchemaViolationException ex) {
            throw new SchemaParseException("Parse error at " + String.valueOf(jsonParser.currentLocation()), ex);
        }
        catch (IOException ex) {
            throw new SchemaParseException("IOException at " + String.valueOf(jsonParser.currentLocation()), ex);
        }
    }

    private static void parseRecord(JsonParser jsonParser, SchemaBuilder builder) throws SchemaParseException, IOException {
        if (jsonParser.currentToken() != JsonToken.START_OBJECT) {
            throw new SchemaParseException("Start object expected at " + String.valueOf(jsonParser.currentLocation()));
        }
        String recordName = null;
        int occurs = -1;
        int min = 1;
        int max = 1;
        ArrayList<FieldDetails> fields = new ArrayList<FieldDetails>();
        while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
            String name = SchemaParser.parseCurrentName(jsonParser);
            if ("name".equals(name)) {
                recordName = SchemaParser.parseString(jsonParser);
                continue;
            }
            if ("occurs".equals(name)) {
                occurs = SchemaParser.parseInteger(jsonParser);
                continue;
            }
            if ("min".equals(name)) {
                min = SchemaParser.parseInteger(jsonParser);
                continue;
            }
            if ("max".equals(name)) {
                max = SchemaParser.parseInteger(jsonParser);
                continue;
            }
            if ("fields".equals(name)) {
                SchemaParser.parseStartArray(jsonParser);
                while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                    SchemaParser.parseField(jsonParser, fields);
                }
                continue;
            }
            throw new SchemaParseException("Unrecognised record field '" + name + "' at " + String.valueOf(jsonParser.currentLocation()));
        }
        if (recordName == null) {
            throw new SchemaParseException("Missing record name at " + String.valueOf(jsonParser.currentLocation()));
        }
        if (occurs != -1) {
            builder.record(recordName, occurs);
        } else {
            builder.record(recordName, min, max);
        }
        for (FieldDetails field : fields) {
            SchemaParser.addField(builder, field);
        }
    }

    private static void parseField(JsonParser jsonParser, List<FieldDetails> fields) throws SchemaParseException, IOException {
        if (jsonParser.currentToken() != JsonToken.START_OBJECT) {
            throw new SchemaParseException("Start object expected at " + String.valueOf(jsonParser.currentLocation()));
        }
        String fieldName = null;
        Schema.Field.Type type = Schema.Field.Type.STRING;
        int occurs = -1;
        int min = 1;
        int max = 1;
        int scale = 2;
        while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
            String name = SchemaParser.parseCurrentName(jsonParser);
            if ("name".equals(name)) {
                fieldName = SchemaParser.parseString(jsonParser);
                continue;
            }
            if ("occurs".equals(name)) {
                occurs = SchemaParser.parseInteger(jsonParser);
                continue;
            }
            if ("min".equals(name)) {
                min = SchemaParser.parseInteger(jsonParser);
                continue;
            }
            if ("max".equals(name)) {
                max = SchemaParser.parseInteger(jsonParser);
                continue;
            }
            if ("scale".equals(name)) {
                scale = SchemaParser.parseInteger(jsonParser);
                continue;
            }
            if ("type".equals(name)) {
                type = SchemaParser.parseType(jsonParser);
                continue;
            }
            throw new SchemaParseException("Unrecognised field key '" + name + "' at " + String.valueOf(jsonParser.currentLocation()));
        }
        if (fieldName == null) {
            throw new SchemaParseException("Missing field name at " + String.valueOf(jsonParser.currentLocation()));
        }
        fields.add(new FieldDetails(fieldName, type, occurs, min, max, scale));
    }

    private static void addField(SchemaBuilder builder, FieldDetails field) {
        if (field.occurs != -1) {
            switch (field.type) {
                case STRING: {
                    builder.string(field.name, field.occurs);
                    break;
                }
                case INTEGER: {
                    builder.integer(field.name, field.occurs);
                    break;
                }
                case DECIMAL: {
                    builder.decimal(field.name, field.scale, field.occurs);
                    break;
                }
            }
        } else {
            switch (field.type) {
                case STRING: {
                    builder.string(field.name, field.min, field.max);
                    break;
                }
                case INTEGER: {
                    builder.integer(field.name, field.min, field.max);
                    break;
                }
                case DECIMAL: {
                    builder.decimal(field.name, field.scale, field.min, field.max);
                    break;
                }
            }
        }
    }

    private static Schema.Field.Type parseType(JsonParser jsonParser) throws SchemaParseException, IOException {
        String typeName = SchemaParser.parseString(jsonParser);
        try {
            return Schema.Field.Type.valueOf(typeName.toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            throw new SchemaParseException("Invalid type value '" + typeName + "'");
        }
    }

    private static void parseStartObject(JsonParser jsonParser) throws SchemaParseException, IOException {
        if (jsonParser.nextToken() != JsonToken.START_OBJECT) {
            throw new SchemaParseException("Start object expected at " + String.valueOf(jsonParser.currentLocation()));
        }
    }

    private static void parseStartArray(JsonParser jsonParser) throws SchemaParseException, IOException {
        if (jsonParser.nextToken() != JsonToken.START_ARRAY) {
            throw new SchemaParseException("Start array expected at " + String.valueOf(jsonParser.currentLocation()));
        }
    }

    private static String parseCurrentName(JsonParser jsonParser) throws SchemaParseException, IOException {
        String name = jsonParser.currentName();
        if (name == null || name.length() == 0) {
            throw new SchemaParseException("Name expected at " + String.valueOf(jsonParser.currentLocation()));
        }
        return name;
    }

    private static String parseString(JsonParser jsonParser) throws SchemaParseException, IOException {
        if (jsonParser.nextToken() == null) {
            throw new SchemaParseException("Unexpected end of schema");
        }
        String value = jsonParser.getValueAsString();
        if (value == null) {
            throw new SchemaParseException("Unable to parse string value at " + String.valueOf(jsonParser.currentLocation()));
        }
        return value;
    }

    private static int parseInteger(JsonParser jsonParser) throws SchemaParseException, IOException {
        if (jsonParser.nextToken() == null) {
            throw new SchemaParseException("Unexpected end of schema");
        }
        int value = jsonParser.getValueAsInt(-99);
        if (value == -99) {
            throw new SchemaParseException("Unable to parse integer value at " + String.valueOf(jsonParser.currentLocation()));
        }
        return value;
    }

    private static final class FieldDetails {
        private final String name;
        private final Schema.Field.Type type;
        private final int occurs;
        private final int min;
        private final int max;
        private final int scale;

        private FieldDetails(String name, Schema.Field.Type type, int occurs, int min, int max, int scale) {
            this.name = name;
            this.type = type;
            this.occurs = occurs;
            this.min = min;
            this.max = max;
            this.scale = scale;
        }
    }
}

