/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.datatype.recordv2.impl.schema;

import com.pushtechnology.diffusion.datatype.recordv2.impl.schema.FieldImpl;
import com.pushtechnology.diffusion.datatype.recordv2.impl.schema.RecordImpl;
import com.pushtechnology.diffusion.datatype.recordv2.impl.schema.SchemaImpl;
import com.pushtechnology.diffusion.datatype.recordv2.schema.Schema;
import com.pushtechnology.diffusion.datatype.recordv2.schema.SchemaBuilder;
import com.pushtechnology.diffusion.datatype.recordv2.schema.SchemaViolationException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public final class SchemaBuilderImpl
implements SchemaBuilder {
    private final List<RecordImpl> theRecords = new ArrayList<RecordImpl>();
    private String theRecordName;
    private int theMin;
    private int theMax;
    private List<FieldImpl> theFields = null;

    @Override
    public SchemaBuilder record(String name) throws SchemaViolationException {
        return this.record(name, 1);
    }

    @Override
    public SchemaBuilder record(String name, int occurs) throws SchemaViolationException {
        this.checkRecordAllowed(name);
        SchemaBuilderImpl.checkOccurs(this.theRecordName, occurs);
        this.newRecord(name, occurs, occurs);
        return this;
    }

    @Override
    public SchemaBuilder record(String name, int min, int max) throws SchemaViolationException {
        this.checkRecordAllowed(name);
        SchemaBuilderImpl.checkMultiplicity(this.theRecordName, min, max);
        this.newRecord(name, min, max);
        return this;
    }

    private void checkRecordAllowed(String name) throws SchemaViolationException {
        Objects.requireNonNull(name);
        if (name.equals(this.theRecordName)) {
            throw new SchemaViolationException("Duplicate record name " + name);
        }
        if (!this.theRecords.isEmpty()) {
            for (Schema.Record record : this.theRecords) {
                if (!record.getName().equals(name)) continue;
                throw new SchemaViolationException("Duplicate record name " + name);
            }
        }
        if (this.theFields != null && this.theMin != this.theMax) {
            throw new SchemaViolationException("Record '" + name + "' not allowed after variable multiplicity record '" + this.theRecordName + "'");
        }
    }

    private void newRecord(String name, int min, int max) {
        if (this.theFields != null) {
            this.addRecord();
        }
        this.theRecordName = name;
        this.theMin = min;
        this.theMax = max;
        this.theFields = new ArrayList<FieldImpl>();
    }

    private void addRecord() throws SchemaViolationException {
        int index;
        if (this.theFields.isEmpty()) {
            throw new SchemaViolationException("No fields specified for record " + this.theRecordName);
        }
        if (this.theRecords.isEmpty()) {
            index = 0;
        } else {
            RecordImpl lastRecord = this.theRecords.get(this.theRecords.size() - 1);
            index = lastRecord.getIndex() + lastRecord.getMax();
        }
        this.theRecords.add(new RecordImpl(this.theRecordName, this.theMin, this.theMax, index, this.theFields));
        this.theRecordName = null;
        this.theMin = 0;
        this.theMax = 0;
        this.theFields = null;
    }

    @Override
    public SchemaBuilder string(String name) throws SchemaViolationException {
        return this.string(name, 1);
    }

    @Override
    public SchemaBuilder string(String name, int occurs) throws SchemaViolationException {
        this.checkAddFieldAllowed(name);
        SchemaBuilderImpl.checkOccurs(name, occurs);
        this.theFields.add(new FieldImpl(name, Schema.Field.Type.STRING, occurs, occurs, 0, this.fieldIndex()));
        return this;
    }

    int fieldIndex() {
        if (this.theFields.isEmpty()) {
            return 0;
        }
        FieldImpl lastField = this.theFields.get(this.theFields.size() - 1);
        return lastField.getIndex() + lastField.getMax();
    }

    @Override
    public SchemaBuilder string(String name, int min, int max) throws SchemaViolationException {
        this.checkAddFieldAllowed(name);
        SchemaBuilderImpl.checkMultiplicity(name, min, max);
        this.theFields.add(new FieldImpl(name, Schema.Field.Type.STRING, min, max, 0, this.fieldIndex()));
        return this;
    }

    @Override
    public SchemaBuilder integer(String name) throws SchemaViolationException {
        return this.integer(name, 1);
    }

    @Override
    public SchemaBuilder integer(String name, int occurs) throws SchemaViolationException {
        this.checkAddFieldAllowed(name);
        SchemaBuilderImpl.checkOccurs(name, occurs);
        this.theFields.add(new FieldImpl(name, Schema.Field.Type.INTEGER, occurs, occurs, 0, this.fieldIndex()));
        return this;
    }

    @Override
    public SchemaBuilder integer(String name, int min, int max) throws SchemaViolationException {
        this.checkAddFieldAllowed(name);
        SchemaBuilderImpl.checkMultiplicity(name, min, max);
        this.theFields.add(new FieldImpl(name, Schema.Field.Type.INTEGER, min, max, 0, this.fieldIndex()));
        return this;
    }

    @Override
    public SchemaBuilder decimal(String name, int scale) throws SchemaViolationException {
        return this.decimal(name, scale, 1);
    }

    @Override
    public SchemaBuilder decimal(String name, int scale, int occurs) throws SchemaViolationException {
        this.checkAddFieldAllowed(name);
        SchemaBuilderImpl.checkScale(name, scale);
        SchemaBuilderImpl.checkOccurs(name, occurs);
        this.theFields.add(new FieldImpl(name, Schema.Field.Type.DECIMAL, occurs, occurs, scale, this.fieldIndex()));
        return this;
    }

    @Override
    public SchemaBuilder decimal(String name, int scale, int min, int max) throws SchemaViolationException {
        this.checkAddFieldAllowed(name);
        SchemaBuilderImpl.checkScale(name, scale);
        SchemaBuilderImpl.checkMultiplicity(name, min, max);
        this.theFields.add(new FieldImpl(name, Schema.Field.Type.DECIMAL, min, max, scale, this.fieldIndex()));
        return this;
    }

    @Override
    public Schema build() throws SchemaViolationException {
        if (this.theFields != null) {
            this.addRecord();
        }
        if (this.theRecords.isEmpty()) {
            throw new SchemaViolationException("Schema has no records");
        }
        return new SchemaImpl(this.theRecords);
    }

    private void checkAddFieldAllowed(String name) throws SchemaViolationException {
        Objects.requireNonNull(name);
        if (this.theFields == null) {
            throw new SchemaViolationException("Cannot add field " + name + " as there is no current record");
        }
        if (!this.theFields.isEmpty()) {
            for (Schema.Field field : this.theFields) {
                if (!field.getName().equals(name)) continue;
                throw new SchemaViolationException("Duplicate field name " + name);
            }
            Schema.Field lastField = this.theFields.get(this.theFields.size() - 1);
            if (lastField.isVariable()) {
                throw new SchemaViolationException("Field '" + name + "' not allowed after variable multiplicity field '" + lastField.getName() + "'");
            }
        }
    }

    private static void checkScale(String name, int scale) throws SchemaViolationException {
        if (scale < 1) {
            throw new SchemaViolationException("'" + name + "' has invalid 'scale' value '" + scale + "'");
        }
    }

    private static void checkOccurs(String name, int occurs) throws SchemaViolationException {
        if (occurs < 1) {
            throw new SchemaViolationException("'" + name + "' has invalid 'occurs' value '" + occurs + "'");
        }
    }

    private static void checkMultiplicity(String name, int min, int max) throws SchemaViolationException {
        if (min < 0) {
            throw new SchemaViolationException("'" + name + "' has invalid 'min' value '" + min + "'");
        }
        if (max != -1 && (max < 1 || max < min)) {
            throw new SchemaViolationException("'" + name + "' has invalid 'max' value '" + max + "'");
        }
    }
}

