/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.datatype.recordv2.impl.model;

import com.pushtechnology.diffusion.datatype.InvalidDataException;
import com.pushtechnology.diffusion.datatype.recordv2.impl.model.AbstractRecordModel;
import com.pushtechnology.diffusion.datatype.recordv2.impl.schema.FieldImpl;
import com.pushtechnology.diffusion.datatype.recordv2.impl.schema.RecordImpl;
import com.pushtechnology.diffusion.datatype.recordv2.impl.schema.SchemaImpl;
import com.pushtechnology.diffusion.datatype.recordv2.schema.SchemaViolationException;
import java.util.List;
import net.jcip.annotations.Immutable;

@Immutable
public final class RecordModelImpl
extends AbstractRecordModel {
    private final List<List<String>> theModel;

    public RecordModelImpl(SchemaImpl schema, List<List<String>> model, boolean validate) {
        super(schema);
        if (validate) {
            RecordModelImpl.validateModel(schema, model);
        }
        this.theModel = model;
    }

    @Override
    protected List<List<String>> model() {
        return this.theModel;
    }

    private static void validateModel(SchemaImpl schema, List<List<String>> model) throws InvalidDataException {
        int modelSize = model.size();
        RecordImpl lastRecord = schema.lastRecord();
        int lastMax = lastRecord.getMax();
        int lastIndex = lastRecord.getIndex();
        if (lastMax != -1 && modelSize > lastIndex + lastMax) {
            throw new InvalidDataException("Too many occurrences of record '" + lastRecord.getName() + "'");
        }
        if (modelSize < lastIndex + lastRecord.getMin()) {
            throw new InvalidDataException("Too few record occurrences");
        }
        for (RecordImpl schemaRecord : schema.records()) {
            int i;
            int startIndex = schemaRecord.getIndex();
            int min = schemaRecord.getMin();
            for (i = startIndex; i < startIndex + min; ++i) {
                RecordModelImpl.validateRecord(schemaRecord, i - startIndex, model.get(i));
            }
            if (!schemaRecord.isVariable()) continue;
            for (i = startIndex + min; i < modelSize; ++i) {
                int index = i - startIndex;
                RecordModelImpl.validateRecord(schemaRecord, index, model.get(i));
            }
        }
    }

    private static void validateRecord(RecordImpl schemaRecord, int recordIndex, List<String> record) throws InvalidDataException {
        int recordSize = record.size();
        FieldImpl lastField = schemaRecord.lastField();
        int lastMax = lastField.getMax();
        int lastIndex = lastField.getIndex();
        if (lastMax != -1 && recordSize > lastIndex + lastMax) {
            throw new InvalidDataException("Too many occurrences of field '" + schemaRecord.getName() + "(" + recordIndex + ")." + lastField.getName() + "'");
        }
        if (recordSize < lastIndex + lastField.getMin()) {
            throw new InvalidDataException("Too few field occurrences in record '" + schemaRecord.getName() + "(" + recordIndex + ")'");
        }
        for (FieldImpl schemaField : schemaRecord.fields()) {
            int i;
            int startIndex = schemaField.getIndex();
            int min = schemaField.getMin();
            for (i = startIndex; i < startIndex + min; ++i) {
                RecordModelImpl.validateField(schemaRecord, recordIndex, schemaField, i - startIndex, record.get(i));
            }
            if (!schemaField.isVariable()) continue;
            for (i = startIndex + min; i < recordSize; ++i) {
                int index = i - startIndex;
                RecordModelImpl.validateField(schemaRecord, recordIndex, schemaField, index, record.get(i));
            }
        }
    }

    private static void validateField(RecordImpl schemaRecord, int recordIndex, FieldImpl schemaField, int index, String value) throws InvalidDataException {
        try {
            schemaField.normalize(value);
        }
        catch (SchemaViolationException ex) {
            throw new InvalidDataException("Invalid value for field '" + schemaRecord.getName() + "(" + recordIndex + ")." + schemaField.getName() + "(" + index + ")'");
        }
    }
}

