/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.datatype.recordv2.impl;

import com.pushtechnology.diffusion.utils.CharsetUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.List;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public final class RecordV2Writer {
    public byte[] toByteArray(List<List<String>> records) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.write(records, baos);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        return baos.toByteArray();
    }

    public void write(List<List<String>> records, OutputStream out) throws IOException {
        if (records.isEmpty()) {
            return;
        }
        if (records.size() == 1 && records.get(0).size() == 0) {
            out.write(4);
            return;
        }
        this.writeRecords(records, out);
    }

    private void writeRecords(List<List<String>> records, OutputStream out) throws IOException {
        boolean recordDelimiter = false;
        for (List<String> record : records) {
            if (recordDelimiter) {
                out.write(1);
            } else {
                recordDelimiter = true;
            }
            if (record.size() == 1 && "".equals(record.get(0))) {
                out.write(5);
                continue;
            }
            boolean fieldDelimiter = false;
            for (String field : record) {
                if (fieldDelimiter) {
                    out.write(2);
                } else {
                    fieldDelimiter = true;
                }
                if (field == null) continue;
                out.write(CharsetUtils.stringToBytesUTF8(field));
            }
        }
    }
}

