/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.datatype.recordv2.impl;

import com.pushtechnology.diffusion.datatype.recordv2.impl.RecordV2Parser;
import com.pushtechnology.diffusion.datatype.recordv2.impl.RecordV2Writer;
import java.util.List;

public final class RecordV2Utils {
    public static final byte RECORD_DELIMITER = 1;
    public static final char RECORD_DELIMITER_CHAR = '\u0001';
    public static final String RECORD_DELIMITER_STRING = Character.toString('\u0001');
    public static final byte FIELD_DELIMITER = 2;
    public static final char FIELD_DELIMITER_CHAR = '\u0002';
    public static final String FIELD_DELIMITER_STRING = Character.toString('\u0002');
    public static final byte EMPTY_FIELD = 3;
    public static final char EMPTY_FIELD_CHAR = '\u0003';
    public static final String EMPTY_FIELD_STRING = Character.toString('\u0003');
    public static final byte RECORD_MU = 4;
    public static final byte FIELD_MU = 5;
    private static final RecordV2Parser RECORD_PARSER = new RecordV2Parser();
    private static final RecordV2Writer RECORD_WRITER = new RecordV2Writer();

    private RecordV2Utils() {
    }

    public static String bytesToString(byte[] bytes, int offset, int len) {
        StringBuilder sb = new StringBuilder(len + 50);
        block7: for (int i = offset; i < offset + len; ++i) {
            switch (bytes[i]) {
                case 2: {
                    sb.append("<FD>");
                    continue block7;
                }
                case 1: {
                    sb.append("<RD>");
                    continue block7;
                }
                case 3: {
                    sb.append("<EF>");
                    continue block7;
                }
                case 5: {
                    sb.append("<FM>");
                    continue block7;
                }
                case 4: {
                    sb.append("<RM>");
                    continue block7;
                }
                default: {
                    sb.append((char)bytes[i]);
                }
            }
        }
        return sb.toString();
    }

    static int recordCount(byte[] bytes, int offset, int length) {
        if (length == 0) {
            return 0;
        }
        if (bytes[0] == 4) {
            return 1;
        }
        int count = 1;
        for (int i = offset; i < offset + length; ++i) {
            if (bytes[i] != 1) continue;
            ++count;
        }
        return count;
    }

    static int fieldCount(byte[] bytes, int offset, int length) {
        if (length == 0) {
            return 0;
        }
        if (bytes[0] == 5) {
            return 1;
        }
        int count = 1;
        for (int i = offset; i < offset + length; ++i) {
            if (bytes[i] != 2) continue;
            ++count;
        }
        return count;
    }

    static int findDelimiter(byte[] bytes, int startIndex, int endIndex, byte delimiter) {
        int pos;
        for (pos = startIndex; pos < endIndex && bytes[pos] != delimiter; ++pos) {
        }
        return pos;
    }

    static boolean recordIsSingleEmptyField(byte[] bytes, int offset, int length) {
        return length == 1 && (bytes[offset] == 5 || bytes[offset] == 3);
    }

    static boolean isSingleEmptyRecord(byte[] bytes, int offset, int length) {
        return length == 1 && bytes[offset] == 4;
    }

    static List<List<String>> parseRecords(byte[] bytes, int offset, int length) {
        return RECORD_PARSER.parse(bytes, offset, length);
    }

    static List<List<String>> parseRecords(byte[] bytes) {
        return RECORD_PARSER.parse(bytes);
    }

    public static byte[] recordsToBytes(List<List<String>> records) {
        return RECORD_WRITER.toByteArray(records);
    }
}

