/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.datatype.recordv2.impl;

import com.pushtechnology.diffusion.datatype.InvalidDataException;
import com.pushtechnology.diffusion.datatype.internal.AbstractBytes;
import com.pushtechnology.diffusion.datatype.recordv2.RecordV2;
import com.pushtechnology.diffusion.datatype.recordv2.RecordV2Delta;
import com.pushtechnology.diffusion.datatype.recordv2.impl.RecordV2DeltaImpl;
import com.pushtechnology.diffusion.datatype.recordv2.impl.RecordV2Utils;
import com.pushtechnology.diffusion.datatype.recordv2.impl.model.RecordModelImpl;
import com.pushtechnology.diffusion.datatype.recordv2.impl.schema.SchemaImpl;
import com.pushtechnology.diffusion.datatype.recordv2.model.RecordModel;
import com.pushtechnology.diffusion.datatype.recordv2.schema.Schema;
import com.pushtechnology.diffusion.utils.tuple.Pair;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public final class RecordV2Impl
extends AbstractBytes
implements RecordV2 {
    public static final RecordV2 EMPTY_VALUE = new RecordV2Impl(new byte[0]);
    public static final RecordV2 RECORD_MU_VALUE = new RecordV2Impl(new byte[]{4});

    public RecordV2Impl(byte[] bytes) {
        this(bytes, 0, bytes.length);
    }

    public RecordV2Impl(byte[] bytes, int offset, int length) {
        super(bytes, offset, length);
    }

    @Override
    public RecordModel asModel(Schema schema) {
        return new RecordModelImpl((SchemaImpl)schema, this.asRecords(), false);
    }

    @Override
    public RecordModel asValidatedModel(Schema schema) throws InvalidDataException {
        return new RecordModelImpl((SchemaImpl)schema, this.asRecords(), true);
    }

    @Override
    public List<List<String>> asRecords() {
        return RecordV2Utils.parseRecords(this.bytes(), this.offset(), this.length());
    }

    @Override
    public List<String> asFields() {
        List<List<String>> records = this.asRecords();
        ArrayList<String> fields = new ArrayList<String>();
        for (List<String> record : records) {
            fields.addAll(record);
        }
        return fields;
    }

    @Override
    public RecordV2Delta diff(RecordV2 original) throws InvalidDataException {
        DiffResult result;
        RecordV2Impl old = (RecordV2Impl)original;
        byte[] oldBytes = old.bytes();
        int oldOffset = old.offset();
        int oldLength = old.length();
        byte[] newBytes = this.bytes();
        int newOffset = this.offset();
        int newLength = this.length();
        if (newLength == 0) {
            if (oldLength == 0) {
                return RecordV2DeltaImpl.NO_CHANGE;
            }
            return RecordV2Impl.deltaForEmptyNewValue();
        }
        if (RecordV2Utils.isSingleEmptyRecord(newBytes, newOffset, newLength)) {
            if (RecordV2Utils.isSingleEmptyRecord(oldBytes, oldOffset, oldLength)) {
                return RecordV2DeltaImpl.NO_CHANGE;
            }
            return RecordV2Impl.deltaForSingleEmptyRecordNewValue(RecordV2Utils.recordCount(oldBytes, oldOffset, oldLength));
        }
        if (oldLength == 0) {
            return RecordV2Impl.deltaForAllNewRecords(newBytes, newOffset, newLength);
        }
        if (RecordV2Utils.isSingleEmptyRecord(oldBytes, oldOffset, oldLength)) {
            return RecordV2Impl.deltaForOldSingleEmptyRecord(newBytes, newOffset, newLength);
        }
        try {
            result = RecordV2Impl.diffRecords(oldBytes, oldOffset, oldLength, newBytes, newOffset, newLength);
        }
        catch (IOException ex) {
            throw new InvalidDataException(ex);
        }
        if (result.hasChanges()) {
            byte[] delta = result.getDelta();
            return new RecordV2DeltaImpl(delta, 0, delta.length, result.getRecordChanges(), result.getFieldChanges());
        }
        return RecordV2DeltaImpl.NO_CHANGE;
    }

    private static DiffResult diffRecords(byte[] oldBytes, int oldOffset, int oldLength, byte[] newBytes, int newOffset, int newLength) throws IOException {
        DiffResult result = new DiffResult();
        int oldCount = RecordV2Utils.recordCount(oldBytes, oldOffset, oldLength);
        int newCount = RecordV2Utils.recordCount(newBytes, newOffset, newLength);
        int same = Math.min(oldCount, newCount);
        int oldStart = oldOffset;
        int oldEnd = oldOffset;
        int newStart = newOffset;
        int newEnd = newOffset;
        boolean delimiter = false;
        for (int i = 0; i < same; ++i) {
            oldEnd = RecordV2Utils.findDelimiter(oldBytes, oldEnd, oldOffset + oldLength, (byte)1);
            newEnd = RecordV2Utils.findDelimiter(newBytes, newEnd, newOffset + newLength, (byte)1);
            if (delimiter) {
                result.write((byte)1);
            } else {
                delimiter = true;
            }
            RecordV2Impl.diffRecord(i, oldBytes, oldStart, oldEnd - oldStart, newBytes, newStart, newEnd - newStart, result);
            oldStart = ++oldEnd;
            newStart = ++newEnd;
        }
        if (newCount != oldCount) {
            if (newCount > oldCount) {
                result.write(newBytes, newStart - 1, newOffset + newLength - newStart + 1);
            }
            result.setRecordsChanged(newCount > oldCount, same);
        }
        return result;
    }

    private static void diffRecord(int recordIndex, byte[] oldBytes, int oldOffset, int oldLength, byte[] newBytes, int newOffset, int newLength, DiffResult result) throws IOException {
        if (newLength == 0) {
            if (oldLength != 0) {
                result.setFieldsRemoved(recordIndex, 0);
            }
            return;
        }
        if (RecordV2Utils.recordIsSingleEmptyField(newBytes, newOffset, newLength)) {
            RecordV2Impl.diffWhenNewIsSingleEmptyField(recordIndex, oldBytes, oldOffset, oldLength, result);
            return;
        }
        if (oldLength == 0) {
            result.write(newBytes, newOffset, newLength);
            result.setFieldsAdded(recordIndex, 0);
            return;
        }
        if (RecordV2Utils.recordIsSingleEmptyField(oldBytes, oldOffset, oldLength)) {
            RecordV2Impl.diffWhenOldIsSingleEmptyField(recordIndex, newBytes, newOffset, newLength, result);
            return;
        }
        RecordV2Impl.diffRecordFields(recordIndex, oldBytes, oldOffset, oldLength, newBytes, newOffset, newLength, result);
    }

    private static void diffWhenNewIsSingleEmptyField(int recordIndex, byte[] oldBytes, int oldOffset, int oldLength, DiffResult result) {
        if (RecordV2Utils.recordIsSingleEmptyField(oldBytes, oldOffset, oldLength)) {
            result.write((byte)5);
        } else {
            int oldCount = RecordV2Utils.fieldCount(oldBytes, oldOffset, oldLength);
            if (oldCount > 1) {
                result.setFieldsRemoved(recordIndex, 1);
            }
            result.write((byte)3);
            result.setChanged();
        }
    }

    private static void diffWhenOldIsSingleEmptyField(int recordIndex, byte[] newBytes, int newOffset, int newLength, DiffResult result) {
        byte b = newBytes[newOffset];
        if (b == 3) {
            result.write(newBytes, newOffset + 1, newLength - 1);
        } else {
            result.write(newBytes, newOffset, newLength);
            if (b != 2) {
                result.setChanged();
            }
        }
        if (RecordV2Utils.fieldCount(newBytes, newOffset, newLength) > 1) {
            result.setFieldsAdded(recordIndex, 1);
        }
    }

    private static void diffRecordFields(int recordIndex, byte[] oldBytes, int oldOffset, int oldLength, byte[] newBytes, int newOffset, int newLength, DiffResult result) throws IOException {
        int oldCount = RecordV2Utils.fieldCount(oldBytes, oldOffset, oldLength);
        int newCount = RecordV2Utils.fieldCount(newBytes, newOffset, newLength);
        int same = Math.min(oldCount, newCount);
        int oldStart = oldOffset;
        int oldEnd = oldOffset;
        int newStart = newOffset;
        int newEnd = newOffset;
        boolean delimiter = false;
        int startSize = result.size();
        for (int i = 0; i < same; ++i) {
            oldEnd = RecordV2Utils.findDelimiter(oldBytes, oldEnd, oldOffset + oldLength, (byte)2);
            newEnd = RecordV2Utils.findDelimiter(newBytes, newEnd, newOffset + newLength, (byte)2);
            if (delimiter) {
                result.write((byte)2);
            } else {
                delimiter = true;
            }
            RecordV2Impl.diffField(oldBytes, oldStart, oldEnd - oldStart, newBytes, newStart, newEnd - newStart, result);
            oldStart = ++oldEnd;
            newStart = ++newEnd;
        }
        if (newCount != oldCount) {
            if (newCount > oldCount) {
                result.write(newBytes, newStart - 1, newOffset + newLength - newStart + 1);
                result.setFieldsAdded(recordIndex, same);
            } else {
                result.setFieldsRemoved(recordIndex, same);
            }
        }
        if (newCount == 1 && startSize == result.size()) {
            result.write((byte)5);
        }
    }

    private static void diffField(byte[] oldBytes, int oldOffset, int oldLength, byte[] newBytes, int newOffset, int newLength, DiffResult result) throws IOException {
        if (RecordV2Impl.fieldsAreEqual(oldBytes, oldOffset, oldLength, newBytes, newOffset, newLength)) {
            return;
        }
        if (newLength == 0) {
            result.write((byte)3);
        } else {
            result.write(newBytes, newOffset, newLength);
        }
        result.setChanged();
    }

    private static boolean fieldsAreEqual(byte[] oldBytes, int oldOffset, int oldLength, byte[] newBytes, int newOffset, int newLength) throws IOException {
        if (oldLength == newLength) {
            if (oldLength == 0 || RecordV2Impl.fieldEquals(oldBytes, oldOffset, newBytes, newOffset, oldLength)) {
                return true;
            }
        } else {
            if (oldLength == 1 && oldBytes[oldOffset] == 3 && newLength == 0) {
                return true;
            }
            if (newLength == 1 && newBytes[newOffset] == 3 && oldLength == 0) {
                return true;
            }
        }
        return false;
    }

    private static boolean fieldEquals(byte[] oldBytes, int oldOffset, byte[] newBytes, int newOffset, int length) {
        for (int i = 0; i < length; ++i) {
            if (oldBytes[oldOffset + i] == newBytes[newOffset + i]) continue;
            return false;
        }
        return true;
    }

    private static RecordV2Delta deltaForEmptyNewValue() {
        return new RecordV2DeltaImpl(new byte[0], 0, 0, Pair.of(false, 0), Collections.emptyMap());
    }

    private static RecordV2Delta deltaForSingleEmptyRecordNewValue(int oldRecordCount) {
        switch (oldRecordCount) {
            case 0: {
                return new RecordV2DeltaImpl(new byte[]{4}, 0, 1, Pair.of(true, 0), Collections.emptyMap());
            }
            case 1: {
                return new RecordV2DeltaImpl(new byte[]{4}, 0, 1, null, Collections.singletonMap(0, Pair.of(false, 0)));
            }
        }
        return new RecordV2DeltaImpl(new byte[]{4}, 0, 1, Pair.of(false, 1), Collections.singletonMap(0, Pair.of(false, 0)));
    }

    private static RecordV2Delta deltaForAllNewRecords(byte[] newBytes, int newOffset, int newLength) {
        return new RecordV2DeltaImpl(newBytes, newOffset, newLength, Pair.of(true, 0), Collections.emptyMap());
    }

    private static RecordV2Delta deltaForOldSingleEmptyRecord(byte[] newBytes, int newOffset, int newLength) {
        int newRecordCount = RecordV2Utils.recordCount(newBytes, newOffset, newLength);
        if (newRecordCount == 1) {
            return new RecordV2DeltaImpl(newBytes, newOffset, newLength, null, Collections.singletonMap(0, Pair.of(true, 0)));
        }
        return new RecordV2DeltaImpl(newBytes, newOffset, newLength, Pair.of(true, 1), newBytes[0] == 1 ? Collections.emptyMap() : Collections.singletonMap(0, Pair.of(true, 0)));
    }

    @Override
    public String toString() {
        return RecordV2Utils.bytesToString(this.bytes(), this.offset(), this.length());
    }

    private static final class DiffResult {
        private final ByteArrayOutputStream delta = new ByteArrayOutputStream();
        private boolean hasChanges = false;
        private Pair<Boolean, Integer> recordChanges = null;
        private final Map<Integer, Pair<Boolean, Integer>> fieldChanges = new HashMap<Integer, Pair<Boolean, Integer>>();

        private DiffResult() {
        }

        private void write(byte b) {
            this.delta.write(b);
        }

        private void write(byte[] b, int off, int len) {
            this.delta.write(b, off, len);
        }

        private byte[] getDelta() {
            return this.delta.toByteArray();
        }

        private int size() {
            return this.delta.size();
        }

        private void setChanged() {
            this.hasChanges = true;
        }

        private boolean hasChanges() {
            return this.hasChanges;
        }

        private void setRecordsChanged(boolean added, int index) {
            this.recordChanges = Pair.of(added, index);
            this.hasChanges = true;
        }

        private Pair<Boolean, Integer> getRecordChanges() {
            return this.recordChanges;
        }

        private void setFieldsAdded(int recordIndex, int fieldIndex) {
            this.fieldChanges.put(recordIndex, Pair.of(true, fieldIndex));
            this.hasChanges = true;
        }

        private void setFieldsRemoved(int recordIndex, int fieldIndex) {
            this.fieldChanges.put(recordIndex, Pair.of(false, fieldIndex));
            this.hasChanges = true;
        }

        private Map<Integer, Pair<Boolean, Integer>> getFieldChanges() {
            if (this.fieldChanges.isEmpty()) {
                return Collections.emptyMap();
            }
            return this.fieldChanges;
        }
    }
}

