/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.datatype.recordv2.impl;

import com.pushtechnology.diffusion.datatype.internal.AbstractBytes;
import com.pushtechnology.diffusion.datatype.recordv2.RecordV2Delta;
import com.pushtechnology.diffusion.datatype.recordv2.impl.RecordV2Utils;
import com.pushtechnology.diffusion.datatype.recordv2.schema.Schema;
import com.pushtechnology.diffusion.datatype.recordv2.schema.SchemaViolationException;
import com.pushtechnology.diffusion.utils.tuple.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public class RecordV2DeltaImpl
extends AbstractBytes
implements RecordV2Delta {
    public static final RecordV2Delta NO_CHANGE = new RecordV2Delta(){

        @Override
        public List<RecordV2Delta.Change> changes(Schema schema) {
            return Collections.emptyList();
        }
    };
    private final Pair<Boolean, Integer> theRecordChanges;
    private final Map<Integer, Pair<Boolean, Integer>> theFieldChanges;

    RecordV2DeltaImpl(byte[] bytes) {
        this(bytes, 0, bytes.length);
    }

    RecordV2DeltaImpl(byte[] bytes, int offset, int length) {
        this(bytes, offset, length, null, Collections.emptyMap());
    }

    RecordV2DeltaImpl(byte[] bytes, int offset, int length, Pair<Boolean, Integer> recordChanges, Map<Integer, Pair<Boolean, Integer>> fieldChanges) {
        super(bytes, offset, length);
        this.theRecordChanges = recordChanges;
        this.theFieldChanges = fieldChanges;
    }

    @Override
    public List<RecordV2Delta.Change> changes(Schema schema) {
        ArrayList<RecordV2Delta.Change> changes = new ArrayList<RecordV2Delta.Change>();
        List<List<String>> data = RecordV2Utils.parseRecords(this.bytes(), this.offset(), this.length());
        int recordIndex = 0;
        for (Schema.Record schemaRecord : schema.getRecords()) {
            if (data.size() < recordIndex + schemaRecord.getMin()) {
                throw new SchemaViolationException("Insufficient records of type " + schemaRecord.getName() + " in delta for schema");
            }
            if (!schemaRecord.isVariable()) {
                recordIndex = this.processFixedRecordChanges(schemaRecord, recordIndex, data, changes);
                continue;
            }
            recordIndex = this.processVariableRecordChanges(schemaRecord, recordIndex, data, changes);
        }
        return changes;
    }

    private int processFixedRecordChanges(Schema.Record schemaRecord, int startIndex, List<List<String>> data, List<RecordV2Delta.Change> changes) {
        int recordIndex = startIndex;
        for (int i = 0; i < schemaRecord.getMin(); ++i) {
            this.processRecordChanges(recordIndex, schemaRecord, i, data.get(recordIndex), changes);
            ++recordIndex;
        }
        return recordIndex;
    }

    private int processVariableRecordChanges(Schema.Record schemaRecord, int startIndex, List<List<String>> data, List<RecordV2Delta.Change> changes) {
        int recordIndex;
        int numberOfNewRecords = data.size();
        int maxAllowed = schemaRecord.getMax();
        if (maxAllowed != -1 && numberOfNewRecords > startIndex + maxAllowed) {
            throw new SchemaViolationException("Too many records of type " + schemaRecord.getName() + " in delta for schema");
        }
        int matchRecordCount = this.theRecordChanges != null && this.theRecordChanges.getFirst() != false ? this.theRecordChanges.getSecond() : numberOfNewRecords;
        int varIndex = 0;
        for (recordIndex = startIndex; recordIndex < matchRecordCount; ++recordIndex) {
            this.processRecordChanges(recordIndex, schemaRecord, varIndex, data.get(recordIndex), changes);
            ++varIndex;
        }
        if (this.theRecordChanges != null) {
            changes.add(new ChangeImpl(this.theRecordChanges.getFirst() != false ? RecordV2Delta.Change.Type.RECORDS_ADDED : RecordV2Delta.Change.Type.RECORDS_REMOVED, schemaRecord.getName(), this.theRecordChanges.getSecond() - startIndex, "", 0));
        }
        return recordIndex;
    }

    private void processRecordChanges(int dataRecordIndex, Schema.Record record, int recordIndex, List<String> data, List<RecordV2Delta.Change> changes) {
        int fieldIndex = 0;
        for (Schema.Field field : record.getFields()) {
            if (!field.isVariable()) {
                fieldIndex = this.processFixedFieldChanges(record, recordIndex, field, fieldIndex, data, changes);
                continue;
            }
            fieldIndex = this.processVariableFieldChanges(record, recordIndex, dataRecordIndex, field, fieldIndex, data, changes);
        }
    }

    private int processFixedFieldChanges(Schema.Record record, int recordIndex, Schema.Field field, int startIndex, List<String> data, List<RecordV2Delta.Change> changes) {
        int numberOfFields = data.size();
        int fieldIndex = startIndex;
        for (int i = 0; i < field.getMin(); ++i) {
            if (fieldIndex >= numberOfFields) {
                throw new SchemaViolationException("Insufficient fields of type " + field.getName() + " in delta for schema record " + record.getName());
            }
            if (!"".equals(data.get(fieldIndex))) {
                changes.add(new ChangeImpl(RecordV2Delta.Change.Type.FIELD_CHANGED, record.getName(), recordIndex, field.getName(), i));
            }
            ++fieldIndex;
        }
        return fieldIndex;
    }

    private int processVariableFieldChanges(Schema.Record record, int recordIndex, int dataRecordIndex, Schema.Field field, int startIndex, List<String> data, List<RecordV2Delta.Change> changes) {
        int fieldIndex;
        int numberOfFields = data.size();
        if (numberOfFields < (fieldIndex = startIndex) + field.getMin()) {
            throw new SchemaViolationException("Insufficient fields of type " + field.getName() + " in delta for schema record " + record.getName());
        }
        Pair<Boolean, Integer> fieldChanges = this.theFieldChanges.get(dataRecordIndex);
        int matchingFieldCount = fieldChanges != null ? fieldChanges.getSecond() : numberOfFields;
        int varIndex = 0;
        while (fieldIndex < matchingFieldCount) {
            if (!"".equals(data.get(fieldIndex))) {
                changes.add(new ChangeImpl(RecordV2Delta.Change.Type.FIELD_CHANGED, record.getName(), recordIndex, field.getName(), varIndex));
            }
            ++varIndex;
            ++fieldIndex;
        }
        if (fieldChanges != null) {
            changes.add(new ChangeImpl(fieldChanges.getFirst() != false ? RecordV2Delta.Change.Type.FIELDS_ADDED : RecordV2Delta.Change.Type.FIELDS_REMOVED, record.getName(), recordIndex, field.getName(), fieldChanges.getSecond()));
        }
        return fieldIndex;
    }

    @Override
    public String toString() {
        return RecordV2Utils.bytesToString(this.bytes(), this.offset(), this.length());
    }

    @Immutable
    private static final class ChangeImpl
    implements RecordV2Delta.Change {
        private final RecordV2Delta.Change.Type theType;
        private final String theRecordName;
        private final int theRecordIndex;
        private final String theFieldName;
        private final int theFieldIndex;
        private final String theKey;

        private ChangeImpl(RecordV2Delta.Change.Type type, String recordName, int recordIndex, String fieldName, int fieldIndex) {
            this.theType = type;
            this.theRecordName = recordName;
            this.theRecordIndex = recordIndex;
            this.theFieldName = fieldName;
            this.theFieldIndex = fieldIndex;
            StringBuilder sb = new StringBuilder();
            sb.append(recordName).append('(').append(recordIndex).append(')');
            if (type != RecordV2Delta.Change.Type.RECORDS_REMOVED && type != RecordV2Delta.Change.Type.RECORDS_ADDED) {
                sb.append('.').append(fieldName).append('(').append(fieldIndex).append(')');
            }
            this.theKey = sb.toString();
        }

        @Override
        public RecordV2Delta.Change.Type type() {
            return this.theType;
        }

        @Override
        public String recordName() {
            return this.theRecordName;
        }

        @Override
        public int recordIndex() {
            return this.theRecordIndex;
        }

        @Override
        public String fieldName() {
            return this.theFieldName;
        }

        @Override
        public int fieldIndex() {
            return this.theFieldIndex;
        }

        @Override
        public String key() {
            return this.theKey;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.theType.hashCode();
            result = 31 * result + this.theKey.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ChangeImpl other = (ChangeImpl)obj;
            return this.theType == other.theType && this.theKey.equals(other.theKey);
        }

        public String toString() {
            return String.valueOf((Object)this.theType) + " " + this.theKey;
        }
    }
}

